<?php

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Symfony\Component\DependencyInjection\ContainerBuilder;

return static function (ContainerBuilder $container): void {

    // 1. Retrieve the actions for opportunities from the symfony container parameters
    $actions = $container->getParameter('module.recordview.actions') ?? [];
    $modules = $actions['modules'] ?? [];
    $opportunities = $modules['opportunities'] ?? [];
    $recordActions = $opportunities['actions'] ?? [];


    // 2. Add the create job Action definition
    $recordActions['create-job'] = [
        'key' => 'opportunity-create-job',

        'labelKey' => 'LBL_CREATE_OPP_JOB', // New label, defined in public/legacy/custom/Extension/modules/Opportunities/Ext/Language

        'asyncProcess' => 'true', // true to call the backend process

        'modes' => ['detail'],

        'acl' => ['view','edit'],

        'aclModule' => 'INSTR_Jobs',

       // 'aclModule' => 'INSTR_Jobs',
        'params' => [
            'expanded' => false, //show as a separate button instead of an action on the drop down
            'linkedModule' => 'INSTR_Jobs'
            // Allow selecting a record from a modal before running action
           // 'selectModal' => [
            //    'module' => 'Accounts'
           // ]
            
            //MORE: Other available params

            // 'displayConfirmation' => true, // Enable to show a confirmation modal before running action
            // 'confirmationLabel' => 'NTC_DELETE_CONFIRMATION' // set the message to show on the confirmation modal

        ]
    ];

    // 3. Add back to the symfony container parameters
    $opportunities['actions'] = $recordActions;
    $modules['opportunities'] = $opportunities;
    $actions['modules'] = $modules;
    $container->setParameter('module.recordview.actions', $actions);
};

