<?php

namespace App\Extension\defaultExt\modules\Opportunities\Process\Service\RecordActions;

use ApiPlatform\Core\Exception\InvalidArgumentException;
use App\Process\Entity\Process;
use App\Process\Service\ProcessHandlerInterface;

class CreateJobOppAction implements ProcessHandlerInterface
{
    protected const MSG_OPTIONS_NOT_FOUND = 'Process options is not defined';
    protected const PROCESS_TYPE = 'record-opportunity-create-job';

    /*
    * CreatejobOppAction constructor
    */
    public function __construct()
    {
        
    }

    /**
     * @inheritDoc
     */
    public function getProcessType(): string
    {
        return self::PROCESS_TYPE;
    }


    public function getHandlerKey(): string
    {
        return $this->getProcessType();
    }

    /**
     * @inheritDoc
     */
    public function requiredAuthRole(): string
    {
        return 'ROLE_USER';
    }

    /**
     * @inheritDoc
     */
    public function getRequiredACLs(Process $process): array
    {
        $options = $process->getOptions();
        $module = $options['module'] ?? '';
        
        $modalRecordModule = $options['params']['linkedModule'] ?? [];
        //$this->getLogger()->debug('Debug Message');

        $acls = [
            $module => [
                [
                    'action' => 'edit'                    
                ]
                ],
            $modalRecordModule => [
                [
                    'action' => 'edit'
                ]
            ]
        ];

        //$modalRecordModule = $options['params']['linkedModule'] ?? [];
        //$modalRecordModule = $modalRecord['module'] ?? '';
        //$modalRecordId = $modalRecord['id'] ?? '';

        /*if ($modalRecordModule !== '') {
            $acls[$modalRecordModule] = [
                [
                    'action' => 'edit'//,
                    //'record' => $modalRecordId
                ]
            ];
        }*/

        return $acls;
    }

    /**
     * @inheritDoc
     */
    public function configure(Process $process): void
    {
        //This process is synchronous
        //We aren't going to store a record on db
        //thus we will use process type as the id
        $process->setId(self::PROCESS_TYPE);
        $process->setAsync(false);
    }

    /**
     * @inheritDoc
     *
     */
    public function validate(Process $process): void
    {
        if (empty($process->getOptions())) {
            throw new InvalidArgumentException(self::MSG_OPTIONS_NOT_FOUND);
        }

        $options = $process->getOptions();

        ['module' => $baseModule, 'id' => $id] = $options;

        if (empty($id) || $baseModule !== 'opportunities') {
            throw new InvalidArgumentException(self::MSG_OPTIONS_NOT_FOUND);
        }

        $modalRecordModule = $options['params']['linkedModule'] ?? [];
        if ($modalRecordModule !== 'INSTR_Jobs') {
            throw new InvalidArgumentException(self::MSG_OPTIONS_NOT_FOUND);
        }
        
/*
        $legacyModuleName = this->moduleNameMapper->toLegacy($options['module']);
        
        if (empty($legacyModuleName) || $this->moduleNameMapper->isValidModule($legacyModuleName)) {
            throw new InvalidArgumentException(self::MSG_OPTIONS_NOT_FOUND);
        }
            */

    }

    /**
     * @inheritDoc
     */
    public function run(Process $process)
    {
        $options = $process->getOptions();
        $module = $options['module'];
        $aclmodule = $options['params']['linkedModule'];
        $id = $options['id'];
        //$oppname = $module['name'];

        //$aclmodule = "INSTR_Jobs";

        $responseData = [
            'handler' => 'redirect',
            'params' => [
                'route' => $aclmodule . '/create',
                'queryParams' => [
                    'name' => $oppname,
                    'description' => $id,//'ME'//$oppname['name'],                    
                ]
            ]
        ];

        $process->setStatus('success');
        $process->setMessages([]);
        $process->setData($responseData);
    }
    
}
