export type ManifestFile<T extends RemoteConfig = RemoteConfig> = {
    [key: string]: string | T;
};
export type Manifest<T extends RemoteConfig = RemoteConfig> = {
    [key: string]: T;
};
export type RemoteConfig = {
    type: 'module' | 'script';
    remoteEntry: string;
    [key: string]: unknown;
};
export type LoadRemoteEntryOptions = LoadRemoteEntryScriptOptions | LoadRemoteEntryEsmOptions;
export type LoadRemoteEntryScriptOptions = {
    type?: 'script';
    remoteEntry: string;
    remoteName: string;
};
export type LoadRemoteEntryEsmOptions = {
    type: 'module';
    remoteEntry: string;
};
export declare function loadRemoteEntry(remoteEntry: string, remoteName: string): Promise<void>;
export declare function loadRemoteEntry(options: LoadRemoteEntryOptions): Promise<void>;
export type LoadRemoteModuleOptions = LoadRemoteModuleScriptOptions | LoadRemoteModuleEsmOptions | LoadRemoteModuleManifestOptions;
export type LoadRemoteModuleScriptOptions = {
    type?: 'script';
    remoteEntry?: string;
    remoteName: string;
    exposedModule: string;
};
export type LoadRemoteModuleEsmOptions = {
    type: 'module';
    remoteEntry: string;
    exposedModule: string;
};
export type LoadRemoteModuleManifestOptions = {
    type: 'manifest';
    remoteName: string;
    exposedModule: string;
};
export declare function loadRemoteModule<T = any>(remoteName: string, exposedModule: string): Promise<T>;
export declare function loadRemoteModule<T = any>(options: LoadRemoteModuleOptions): Promise<T>;
export declare function setManifest(manifest: ManifestFile, skipRemoteEntries?: boolean): Promise<void>;
export declare function getManifest<T extends Manifest>(): T;
export declare function initFederation(manifest: string | ManifestFile, skipRemoteEntries?: boolean): Promise<void>;
export declare function loadManifest(configFile: string, skipRemoteEntries?: boolean): Promise<void>;
