"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = remove;
const tslib_1 = require("tslib");
const path = require("path");
const rxjs_1 = require("rxjs");
const schematic_1 = require("../mf/schematic");
function remove(options) {
    return function (tree) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const workspaceFileName = (0, schematic_1.getWorkspaceFileName)(tree);
            const workspace = JSON.parse(tree.read(workspaceFileName).toString('utf8'));
            const normalized = normalize(options, workspace);
            removeBootstrap(normalized, tree);
            updateBuildConfig(normalized);
            updateServeConfig(normalized);
            tree.overwrite(workspaceFileName, JSON.stringify(workspace, null, 2));
            return (0, rxjs_1.noop)();
        });
    };
}
function updateBuildConfig(normalized) {
    const build = normalized.projectConfig.architect.build;
    build.builder = '@angular-devkit/build-angular:browser';
    delete build.options.extraWebpackConfig;
    delete build.options.customWebpackConfig;
    const buildProd = build.configurations.production;
    delete buildProd.extraWebpackConfig;
    delete buildProd.customWebpackConfig;
}
function updateServeConfig(normalized) {
    var _a, _b;
    const serve = normalized.projectConfig.architect.serve;
    serve.builder = '@angular-devkit/build-angular:dev-server';
    delete serve.options.extraWebpackConfig;
    delete serve.options.customWebpackConfig;
    const serveProd = (_a = serve === null || serve === void 0 ? void 0 : serve.configurations) === null || _a === void 0 ? void 0 : _a.production;
    if (serveProd) {
        delete serveProd.extraWebpackConfig;
        delete serveProd.customWebpackConfig;
    }
    const prodTarget = serveProd === null || serveProd === void 0 ? void 0 : serveProd.browserTarget;
    if (prodTarget) {
        delete serveProd.browserTarget;
        serveProd.buildTarget = prodTarget;
    }
    const serveDev = (_b = serve === null || serve === void 0 ? void 0 : serve.configurations) === null || _b === void 0 ? void 0 : _b.development;
    const devTarget = serveDev === null || serveDev === void 0 ? void 0 : serveDev.browserTarget;
    if (devTarget) {
        delete serveDev.browserTarget;
        serveDev.buildTarget = devTarget;
    }
}
function normalize(options, workspace) {
    var _a, _b, _c;
    if (!options.project) {
        options.project = workspace.defaultProject;
    }
    if (!options.project && Object.keys(workspace.projects).length > 0) {
        options.project = Object.keys(workspace.projects)[0];
    }
    if (!options.project) {
        throw new Error(`No default project found. Please specifiy a project name!`);
    }
    const projectName = options.project;
    const projectConfig = workspace.projects[projectName];
    if (!((_c = (_b = (_a = projectConfig === null || projectConfig === void 0 ? void 0 : projectConfig.architect) === null || _a === void 0 ? void 0 : _a.build) === null || _b === void 0 ? void 0 : _b.options) === null || _c === void 0 ? void 0 : _c.main)) {
        throw new Error(`architect.build.options.main not found for project ` + projectName);
    }
    return { projectConfig, projectName };
}
function removeBootstrap(normalized, tree) {
    const currentMain = normalized.projectConfig.architect.build.options.main;
    const mainPath = path
        .join(path.dirname(currentMain), 'main.ts')
        .replace(/\\/g, '/');
    const bootstrapPath = path
        .join(path.dirname(currentMain), 'bootstrap.ts')
        .replace(/\\/g, '/');
    const content = tree.readText(bootstrapPath);
    tree.overwrite(mainPath, content);
    tree.delete(bootstrapPath);
}
//# sourceMappingURL=schematic.js.map