"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.print = print;
const tslib_1 = require("tslib");
const crypt = require("crypto");
const chalk_1 = tslib_1.__importDefault(require("chalk"));
const wordWrap = require("word-wrap");
function correctColor(color) {
    let result = '';
    for (let i = 0; i < color.length; i += 2) {
        const a = color.charAt(i);
        const b = color.charAt(i + 1);
        const ia = parseInt(a);
        if (isNaN(ia)) {
            result += a;
        }
        else if (ia < 5) {
            result += (ia + 5).toString(16);
        }
        else {
            result += a;
        }
        result += b;
    }
    return result;
}
function print(prefix, prefixSize, message, error = false) {
    const hash = crypt.createHash('sha256').update(prefix).digest('hex');
    const color = '#' + correctColor(hash.substring(6, 12));
    prefix = prefix.padEnd(prefixSize);
    if (message.endsWith('\n')) {
        message = message.substring(0, message.length - 1);
    }
    const coloredPrefix = chalk_1.default.hex(color)(prefix) + ' | ';
    const lines = message.split('\n');
    const lineSize = process.stdout.columns - prefixSize - 10;
    for (const line of lines) {
        const wrapped = wordWrap(line, { width: lineSize });
        const sublines = wrapped.split('\n');
        for (const subline of sublines) {
            const trimmed = subline.trim();
            const coloredSubline = error ? chalk_1.default.redBright(trimmed) : trimmed;
            const output = coloredPrefix + coloredSubline;
            console.log(output);
        }
    }
}
//# sourceMappingURL=colors.js.map