"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModifyEntryPlugin = void 0;
class ModifyEntryPlugin {
    constructor(config) {
        this.config = config;
    }
    apply(compiler) {
        const mergeEntry = (keyFn, key) => [
            ...(keyFn(this.config[key]) || []),
            ...(keyFn(compiler.options.entry[key]) || []),
        ];
        const cfgOrRemove = (objFn, valueFn, key) => {
            const values = mergeEntry(valueFn, key);
            return values.length > 0 ? objFn(values) : {};
        };
        Object.keys(this.config).forEach((key) => {
            compiler.options.entry[key] = Object.assign(Object.assign({}, cfgOrRemove((v) => ({ import: v }), (c) => c.import, key)), cfgOrRemove((v) => ({ dependOn: v }), (c) => c.dependOn, key));
        });
    }
}
exports.ModifyEntryPlugin = ModifyEntryPlugin;
//# sourceMappingURL=modify-entry-plugin.js.map