/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { SelectionModel } from '@angular/cdk/collections';
/**
 * Base tree control. It has basic toggle/expand/collapse operations on a single data node.
 *
 * @deprecated Use one of levelAccessor or childrenAccessor. To be removed in a future version.
 * @breaking-change 21.0.0
 */
export class BaseTreeControl {
    constructor() {
        /** A selection model with multi-selection to track expansion status. */
        this.expansionModel = new SelectionModel(true);
    }
    /** Toggles one single data node's expanded/collapsed state. */
    toggle(dataNode) {
        this.expansionModel.toggle(this._trackByValue(dataNode));
    }
    /** Expands one single data node. */
    expand(dataNode) {
        this.expansionModel.select(this._trackByValue(dataNode));
    }
    /** Collapses one single data node. */
    collapse(dataNode) {
        this.expansionModel.deselect(this._trackByValue(dataNode));
    }
    /** Whether a given data node is expanded or not. Returns true if the data node is expanded. */
    isExpanded(dataNode) {
        return this.expansionModel.isSelected(this._trackByValue(dataNode));
    }
    /** Toggles a subtree rooted at `node` recursively. */
    toggleDescendants(dataNode) {
        this.expansionModel.isSelected(this._trackByValue(dataNode))
            ? this.collapseDescendants(dataNode)
            : this.expandDescendants(dataNode);
    }
    /** Collapse all dataNodes in the tree. */
    collapseAll() {
        this.expansionModel.clear();
    }
    /** Expands a subtree rooted at given data node recursively. */
    expandDescendants(dataNode) {
        let toBeProcessed = [dataNode];
        toBeProcessed.push(...this.getDescendants(dataNode));
        this.expansionModel.select(...toBeProcessed.map(value => this._trackByValue(value)));
    }
    /** Collapses a subtree rooted at given data node recursively. */
    collapseDescendants(dataNode) {
        let toBeProcessed = [dataNode];
        toBeProcessed.push(...this.getDescendants(dataNode));
        this.expansionModel.deselect(...toBeProcessed.map(value => this._trackByValue(value)));
    }
    _trackByValue(value) {
        return this.trackBy ? this.trackBy(value) : value;
    }
}
//# sourceMappingURL=data:application/json;base64,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