/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Returns an error to be thrown when there is no usable data.
 * @docs-private
 */
export function getTreeNoValidDataSourceError() {
    return Error(`A valid data source must be provided.`);
}
/**
 * Returns an error to be thrown when there are multiple nodes that are missing a when function.
 * @docs-private
 */
export function getTreeMultipleDefaultNodeDefsError() {
    return Error(`There can only be one default row without a when predicate function.`);
}
/**
 * Returns an error to be thrown when there are no matching node defs for a particular set of data.
 * @docs-private
 */
export function getTreeMissingMatchingNodeDefError() {
    return Error(`Could not find a matching node definition for the provided node data.`);
}
/**
 * Returns an error to be thrown when there is no tree control.
 * @docs-private
 */
export function getTreeControlMissingError() {
    return Error(`Could not find a tree control, levelAccessor, or childrenAccessor for the tree.`);
}
/**
 * Returns an error to be thrown when there are multiple ways of specifying children or level
 * provided to the tree.
 * @docs-private
 */
export function getMultipleTreeControlsError() {
    return Error(`More than one of tree control, levelAccessor, or childrenAccessor were provided.`);
}
//# sourceMappingURL=data:application/json;base64,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