"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProjectTargetOptions = getProjectTargetOptions;
exports.getProjectBuildTargets = getProjectBuildTargets;
exports.getProjectTestTargets = getProjectTestTargets;
const schematics_1 = require("@angular-devkit/schematics");
/** Resolves the architect options for the build target of the given project. */
function getProjectTargetOptions(project, buildTarget) {
    const options = project.targets?.get(buildTarget)?.options;
    if (!options) {
        throw new schematics_1.SchematicsException(`Cannot determine project target configuration for: ${buildTarget}.`);
    }
    return options;
}
/** Gets all of the default CLI-provided build targets in a project. */
function getProjectBuildTargets(project) {
    return getTargetsByBuilderName(project, builder => builder === '@angular-devkit/build-angular:application' ||
        builder === '@angular-devkit/build-angular:browser' ||
        builder === '@angular-devkit/build-angular:browser-esbuild' ||
        builder === '@angular/build:application');
}
/** Gets all of the default CLI-provided testing targets in a project. */
function getProjectTestTargets(project) {
    return getTargetsByBuilderName(project, builder => builder === '@angular-devkit/build-angular:karma');
}
/** Gets all targets from the given project that pass a predicate check. */
function getTargetsByBuilderName(project, predicate) {
    return Array.from(project.targets.keys())
        .filter(name => predicate(project.targets.get(name)?.builder))
        .map(name => project.targets.get(name));
}
//# sourceMappingURL=data:application/json;base64,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