/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { OpKind } from '../enums';
import { TRAIT_CONSUMES_VARS } from '../traits';
import { NEW_OP } from './shared';
export function createHostPropertyOp(name, expression, isAnimationTrigger, i18nContext, securityContext, sourceSpan) {
    return {
        kind: OpKind.HostProperty,
        name,
        expression,
        isAnimationTrigger,
        i18nContext,
        securityContext,
        sanitizer: null,
        sourceSpan,
        ...TRAIT_CONSUMES_VARS,
        ...NEW_OP,
    };
}
//# sourceMappingURL=data:application/json;base64,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