/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import * as o from '../../../output/output_ast';
import * as ir from '../ir';
export const BINARY_OPERATORS = new Map([
    ['&&', o.BinaryOperator.And],
    ['>', o.BinaryOperator.Bigger],
    ['>=', o.BinaryOperator.BiggerEquals],
    ['|', o.BinaryOperator.BitwiseOr],
    ['&', o.BinaryOperator.BitwiseAnd],
    ['/', o.BinaryOperator.Divide],
    ['==', o.BinaryOperator.Equals],
    ['===', o.BinaryOperator.Identical],
    ['<', o.BinaryOperator.Lower],
    ['<=', o.BinaryOperator.LowerEquals],
    ['-', o.BinaryOperator.Minus],
    ['%', o.BinaryOperator.Modulo],
    ['*', o.BinaryOperator.Multiply],
    ['!=', o.BinaryOperator.NotEquals],
    ['!==', o.BinaryOperator.NotIdentical],
    ['??', o.BinaryOperator.NullishCoalesce],
    ['||', o.BinaryOperator.Or],
    ['+', o.BinaryOperator.Plus],
]);
export function namespaceForKey(namespacePrefixKey) {
    const NAMESPACES = new Map([
        ['svg', ir.Namespace.SVG],
        ['math', ir.Namespace.Math],
    ]);
    if (namespacePrefixKey === null) {
        return ir.Namespace.HTML;
    }
    return NAMESPACES.get(namespacePrefixKey) ?? ir.Namespace.HTML;
}
export function keyForNamespace(namespace) {
    const NAMESPACES = new Map([
        ['svg', ir.Namespace.SVG],
        ['math', ir.Namespace.Math],
    ]);
    for (const [k, n] of NAMESPACES.entries()) {
        if (n === namespace) {
            return k;
        }
    }
    return null; // No namespace prefix for HTML
}
export function prefixWithNamespace(strippedTag, namespace) {
    if (namespace === ir.Namespace.HTML) {
        return strippedTag;
    }
    return `:${keyForNamespace(namespace)}:${strippedTag}`;
}
export function literalOrArrayLiteral(value) {
    if (Array.isArray(value)) {
        return o.literalArr(value.map(literalOrArrayLiteral));
    }
    return o.literal(value);
}
//# sourceMappingURL=data:application/json;base64,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