/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
export const Attribute = {
    /**
     * The jsaction attribute defines a mapping of a DOM event to a
     * generic event (aka jsaction), to which the actual event handlers
     * that implement the behavior of the application are bound. The
     * value is a semicolon separated list of colon separated pairs of
     * an optional DOM event name and a jsaction name. If the optional
     * DOM event name is omitted, 'click' is assumed. The jsaction names
     * are dot separated pairs of a namespace and a simple jsaction
     * name.
     *
     * See grammar in README.md for expected syntax in the attribute value.
     */
    JSACTION: 'jsaction',
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXR0cmlidXRlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9wcmltaXRpdmVzL2V2ZW50LWRpc3BhdGNoL3NyYy9hdHRyaWJ1dGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUgsTUFBTSxDQUFDLE1BQU0sU0FBUyxHQUFHO0lBQ3ZCOzs7Ozs7Ozs7OztPQVdHO0lBQ0gsUUFBUSxFQUFFLFVBQW1CO0NBQzlCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5kZXYvbGljZW5zZVxuICovXG5cbmV4cG9ydCBjb25zdCBBdHRyaWJ1dGUgPSB7XG4gIC8qKlxuICAgKiBUaGUganNhY3Rpb24gYXR0cmlidXRlIGRlZmluZXMgYSBtYXBwaW5nIG9mIGEgRE9NIGV2ZW50IHRvIGFcbiAgICogZ2VuZXJpYyBldmVudCAoYWthIGpzYWN0aW9uKSwgdG8gd2hpY2ggdGhlIGFjdHVhbCBldmVudCBoYW5kbGVyc1xuICAgKiB0aGF0IGltcGxlbWVudCB0aGUgYmVoYXZpb3Igb2YgdGhlIGFwcGxpY2F0aW9uIGFyZSBib3VuZC4gVGhlXG4gICAqIHZhbHVlIGlzIGEgc2VtaWNvbG9uIHNlcGFyYXRlZCBsaXN0IG9mIGNvbG9uIHNlcGFyYXRlZCBwYWlycyBvZlxuICAgKiBhbiBvcHRpb25hbCBET00gZXZlbnQgbmFtZSBhbmQgYSBqc2FjdGlvbiBuYW1lLiBJZiB0aGUgb3B0aW9uYWxcbiAgICogRE9NIGV2ZW50IG5hbWUgaXMgb21pdHRlZCwgJ2NsaWNrJyBpcyBhc3N1bWVkLiBUaGUganNhY3Rpb24gbmFtZXNcbiAgICogYXJlIGRvdCBzZXBhcmF0ZWQgcGFpcnMgb2YgYSBuYW1lc3BhY2UgYW5kIGEgc2ltcGxlIGpzYWN0aW9uXG4gICAqIG5hbWUuXG4gICAqXG4gICAqIFNlZSBncmFtbWFyIGluIFJFQURNRS5tZCBmb3IgZXhwZWN0ZWQgc3ludGF4IGluIHRoZSBhdHRyaWJ1dGUgdmFsdWUuXG4gICAqL1xuICBKU0FDVElPTjogJ2pzYWN0aW9uJyBhcyBjb25zdCxcbn07XG4iXX0=