/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { addEvents, createEarlyJsactionData, getQueuedEventInfos, registerDispatcher, removeAllEventListeners, } from './earlyeventcontract';
/**
 * Creates an `EarlyJsactionData`, adds events to it, and populates it on a nested object on
 * the window.
 */
export function bootstrapAppScopedEarlyEventContract(container, appId, bubbleEventTypes, captureEventTypes, dataContainer = window) {
    const earlyJsactionData = createEarlyJsactionData(container);
    if (!dataContainer._ejsas) {
        dataContainer._ejsas = {};
    }
    dataContainer._ejsas[appId] = earlyJsactionData;
    addEvents(earlyJsactionData, bubbleEventTypes);
    addEvents(earlyJsactionData, captureEventTypes, /* capture= */ true);
}
/** Get the queued `EventInfo` objects that were dispatched before a dispatcher was registered. */
export function getAppScopedQueuedEventInfos(appId, dataContainer = window) {
    return getQueuedEventInfos(dataContainer._ejsas?.[appId]);
}
/**
 * Registers a dispatcher function on the `EarlyJsactionData` present on the nested object on the
 * window.
 */
export function registerAppScopedDispatcher(restriction, appId, dispatcher, dataContainer = window) {
    registerDispatcher(dataContainer._ejsas?.[appId], dispatcher);
}
/** Removes all event listener handlers. */
export function removeAllAppScopedEventListeners(appId, dataContainer = window) {
    removeAllEventListeners(dataContainer._ejsas?.[appId]);
}
/** Clear the early event contract. */
export function clearAppScopedEarlyEventContract(appId, dataContainer = window) {
    if (!dataContainer._ejsas) {
        return;
    }
    dataContainer._ejsas[appId] = undefined;
}
//# sourceMappingURL=data:application/json;base64,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