/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { addEvents, createEarlyJsactionData, getQueuedEventInfos, registerDispatcher, removeAllEventListeners, } from './earlyeventcontract';
/** Creates an `EarlyJsactionData`, adds events to it, and populates it on the window. */
export function bootstrapGlobalEarlyEventContract(bubbleEventTypes, captureEventTypes) {
    const earlyJsactionData = createEarlyJsactionData(window.document.documentElement);
    addEvents(earlyJsactionData, bubbleEventTypes);
    addEvents(earlyJsactionData, captureEventTypes, /* capture= */ true);
    window._ejsa = earlyJsactionData;
}
/** Get the queued `EventInfo` objects that were dispatched before a dispatcher was registered. */
export function getGlobalQueuedEventInfos() {
    return getQueuedEventInfos(window._ejsa);
}
/** Registers a dispatcher function on the `EarlyJsactionData` present on the window. */
export function registerGlobalDispatcher(restriction, dispatcher) {
    registerDispatcher(window._ejsa, dispatcher);
}
/** Removes all event listener handlers. */
export function removeAllGlobalEventListeners() {
    removeAllEventListeners(window._ejsa);
}
/** Removes the global early event contract. */
export function clearGlobalEarlyEventContract() {
    window._ejsa = undefined;
}
//# sourceMappingURL=data:application/json;base64,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