/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/**
 * Merge multiple application configurations from left to right.
 *
 * @param configs Two or more configurations to be merged.
 * @returns A merged [ApplicationConfig](api/core/ApplicationConfig).
 *
 * @publicApi
 */
export function mergeApplicationConfig(...configs) {
    return configs.reduce((prev, curr) => {
        return Object.assign(prev, curr, { providers: [...prev.providers, ...curr.providers] });
    }, { providers: [] });
}
//# sourceMappingURL=data:application/json;base64,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