/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { assertInInjectionContext } from '../../di';
import { REQUIRED_UNSET_VALUE } from '../input/input_signal_node';
import { createModelSignal } from './model_signal';
export function modelFunction(initialValue) {
    ngDevMode && assertInInjectionContext(model);
    return createModelSignal(initialValue);
}
export function modelRequiredFunction() {
    ngDevMode && assertInInjectionContext(model);
    return createModelSignal(REQUIRED_UNSET_VALUE);
}
/**
 * `model` declares a writeable signal that is exposed as an input/output
 * pair on the containing directive.
 *
 * The input name is taken either from the class member or from the `alias` option.
 * The output name is generated by taking the input name and appending `Change`.
 *
 * @usageNotes
 *
 * To use `model()`, import the function from `@angular/core`.
 *
 * ```
 * import {model} from '@angular/core`;
 * ```
 *
 * Inside your component, introduce a new class member and initialize
 * it with a call to `model` or `model.required`.
 *
 * ```ts
 * @Directive({
 *   ...
 * })
 * export class MyDir {
 *   firstName = model<string>();            // ModelSignal<string|undefined>
 *   lastName  = model.required<string>();   // ModelSignal<string>
 *   age       = model(0);                   // ModelSignal<number>
 * }
 * ```
 *
 * Inside your component template, you can display the value of a `model`
 * by calling the signal.
 *
 * ```html
 * <span>{{firstName()}}</span>
 * ```
 *
 * Updating the `model` is equivalent to updating a writable signal.
 *
 * ```ts
 * updateName(newFirstName: string): void {
 *   this.firstName.set(newFirstName);
 * }
 * ```
 *
 * @developerPreview
 * @initializerApiFunction
 */
export const model = (() => {
    // Note: This may be considered a side-effect, but nothing will depend on
    // this assignment, unless this `model` constant export is accessed. It's a
    // self-contained side effect that is local to the user facing `model` export.
    modelFunction.required = modelRequiredFunction;
    return modelFunction;
})();
//# sourceMappingURL=data:application/json;base64,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