/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { InjectionToken } from '../../di/injection_token';
/**
 * Injectable that is notified when an `LView` is made aware of changes to application state.
 */
export class ChangeDetectionScheduler {
}
/** Token used to indicate if zoneless was enabled via provideZonelessChangeDetection(). */
export const ZONELESS_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || ngDevMode ? 'Zoneless enabled' : '', { providedIn: 'root', factory: () => false });
/** Token used to indicate `provideExperimentalZonelessChangeDetection` was used. */
export const PROVIDED_ZONELESS = new InjectionToken(typeof ngDevMode === 'undefined' || ngDevMode ? 'Zoneless provided' : '', { providedIn: 'root', factory: () => false });
export const ZONELESS_SCHEDULER_DISABLED = new InjectionToken(typeof ngDevMode === 'undefined' || ngDevMode ? 'scheduler disabled' : '');
// TODO(atscott): Remove in v19. Scheduler should be done with runOutsideAngular.
export const SCHEDULE_IN_ROOT_ZONE = new InjectionToken(typeof ngDevMode === 'undefined' || ngDevMode ? 'run changes outside zone in root' : '');
//# sourceMappingURL=data:application/json;base64,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