/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/**
 * Describes the state of defer block dependency loading.
 */
export var DeferDependenciesLoadingState;
(function (DeferDependenciesLoadingState) {
    /** Initial state, dependency loading is not yet triggered */
    DeferDependenciesLoadingState[DeferDependenciesLoadingState["NOT_STARTED"] = 0] = "NOT_STARTED";
    /** Dependency loading is in progress */
    DeferDependenciesLoadingState[DeferDependenciesLoadingState["IN_PROGRESS"] = 1] = "IN_PROGRESS";
    /** Dependency loading has completed successfully */
    DeferDependenciesLoadingState[DeferDependenciesLoadingState["COMPLETE"] = 2] = "COMPLETE";
    /** Dependency loading has failed */
    DeferDependenciesLoadingState[DeferDependenciesLoadingState["FAILED"] = 3] = "FAILED";
})(DeferDependenciesLoadingState || (DeferDependenciesLoadingState = {}));
/** Slot index where `minimum` parameter value is stored. */
export const MINIMUM_SLOT = 0;
/** Slot index where `after` parameter value is stored. */
export const LOADING_AFTER_SLOT = 1;
/**
 * Describes the current state of this defer block instance.
 *
 * @publicApi
 */
export var DeferBlockState;
(function (DeferBlockState) {
    /** The placeholder block content is rendered */
    DeferBlockState[DeferBlockState["Placeholder"] = 0] = "Placeholder";
    /** The loading block content is rendered */
    DeferBlockState[DeferBlockState["Loading"] = 1] = "Loading";
    /** The main content block content is rendered */
    DeferBlockState[DeferBlockState["Complete"] = 2] = "Complete";
    /** The error block content is rendered */
    DeferBlockState[DeferBlockState["Error"] = 3] = "Error";
})(DeferBlockState || (DeferBlockState = {}));
/**
 * Describes the initial state of this defer block instance.
 *
 * Note: this state is internal only and *must* be represented
 * with a number lower than any value in the `DeferBlockState` enum.
 */
export var DeferBlockInternalState;
(function (DeferBlockInternalState) {
    /** Initial state. Nothing is rendered yet. */
    DeferBlockInternalState[DeferBlockInternalState["Initial"] = -1] = "Initial";
})(DeferBlockInternalState || (DeferBlockInternalState = {}));
export const NEXT_DEFER_BLOCK_STATE = 0;
// Note: it's *important* to keep the state in this slot, because this slot
// is used by runtime logic to differentiate between LViews, LContainers and
// other types (see `isLView` and `isLContainer` functions). In case of defer
// blocks, this slot would always be a number.
export const DEFER_BLOCK_STATE = 1;
export const STATE_IS_FROZEN_UNTIL = 2;
export const LOADING_AFTER_CLEANUP_FN = 3;
export const TRIGGER_CLEANUP_FNS = 4;
export const PREFETCH_TRIGGER_CLEANUP_FNS = 5;
/**
 * Options for configuring defer blocks behavior.
 * @publicApi
 */
export var DeferBlockBehavior;
(function (DeferBlockBehavior) {
    /**
     * Manual triggering mode for defer blocks. Provides control over when defer blocks render
     * and which state they render.
     */
    DeferBlockBehavior[DeferBlockBehavior["Manual"] = 0] = "Manual";
    /**
     * Playthrough mode for defer blocks. This mode behaves like defer blocks would in a browser.
     * This is the default behavior in test environments.
     */
    DeferBlockBehavior[DeferBlockBehavior["Playthrough"] = 1] = "Playthrough";
})(DeferBlockBehavior || (DeferBlockBehavior = {}));
//# sourceMappingURL=data:application/json;base64,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