/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { EMPTY_ARRAY } from '../util/empty';
import { stringify } from '../util/stringify';
import { importProvidersFrom } from './provider_collection';
import { getNullInjector, R3Injector } from './r3_injector';
/**
 * Create a new `Injector` which is configured using a `defType` of `InjectorType<any>`s.
 */
export function createInjector(defType, parent = null, additionalProviders = null, name) {
    const injector = createInjectorWithoutInjectorInstances(defType, parent, additionalProviders, name);
    injector.resolveInjectorInitializers();
    return injector;
}
/**
 * Creates a new injector without eagerly resolving its injector types. Can be used in places
 * where resolving the injector types immediately can lead to an infinite loop. The injector types
 * should be resolved at a later point by calling `_resolveInjectorDefTypes`.
 */
export function createInjectorWithoutInjectorInstances(defType, parent = null, additionalProviders = null, name, scopes = new Set()) {
    const providers = [additionalProviders || EMPTY_ARRAY, importProvidersFrom(defType)];
    name = name || (typeof defType === 'object' ? undefined : stringify(defType));
    return new R3Injector(providers, parent || getNullInjector(), name || null, scopes);
}
//# sourceMappingURL=data:application/json;base64,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