/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/**
 * @module
 * @description
 * The `di` module provides dependency injection container services.
 */
export * from './metadata';
export { assertInInjectionContext, runInInjectionContext } from './contextual';
export { InjectFlags } from './interface/injector';
export { ɵɵdefineInjectable, defineInjectable, ɵɵdefineInjector, } from './interface/defs';
export { forwardRef, resolveForwardRef } from './forward_ref';
export { Injectable } from './injectable';
export { Injector } from './injector';
export { EnvironmentInjector } from './r3_injector';
export { importProvidersFrom, makeEnvironmentProviders, } from './provider_collection';
export { ENVIRONMENT_INITIALIZER } from './initializer_token';
export { ɵɵinject, inject, ɵɵinvalidFactoryDep } from './injector_compatibility';
export { INJECTOR } from './injector_token';
export { InjectionToken } from './injection_token';
export { HostAttributeToken } from './host_attribute_token';
export { HOST_TAG_NAME } from './host_tag_name_token';
//# sourceMappingURL=data:application/json;base64,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