/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { InjectionToken } from './injection_token';
/**
 * A multi-provider token for initialization functions that will run upon construction of an
 * environment injector.
 *
 * Note: As opposed to the `APP_INITIALIZER` token, the `ENVIRONMENT_INITIALIZER` functions are not awaited,
 * hence they should not be `async`.
 *
 * @publicApi
 */
export const ENVIRONMENT_INITIALIZER = new InjectionToken(ngDevMode ? 'ENVIRONMENT_INITIALIZER' : '');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5pdGlhbGl6ZXJfdG9rZW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb3JlL3NyYy9kaS9pbml0aWFsaXplcl90b2tlbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSCxPQUFPLEVBQUMsY0FBYyxFQUFDLE1BQU0sbUJBQW1CLENBQUM7QUFFakQ7Ozs7Ozs7O0dBUUc7QUFDSCxNQUFNLENBQUMsTUFBTSx1QkFBdUIsR0FBRyxJQUFJLGNBQWMsQ0FDdkQsU0FBUyxDQUFDLENBQUMsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUMzQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuZGV2L2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge0luamVjdGlvblRva2VufSBmcm9tICcuL2luamVjdGlvbl90b2tlbic7XG5cbi8qKlxuICogQSBtdWx0aS1wcm92aWRlciB0b2tlbiBmb3IgaW5pdGlhbGl6YXRpb24gZnVuY3Rpb25zIHRoYXQgd2lsbCBydW4gdXBvbiBjb25zdHJ1Y3Rpb24gb2YgYW5cbiAqIGVudmlyb25tZW50IGluamVjdG9yLlxuICpcbiAqIE5vdGU6IEFzIG9wcG9zZWQgdG8gdGhlIGBBUFBfSU5JVElBTElaRVJgIHRva2VuLCB0aGUgYEVOVklST05NRU5UX0lOSVRJQUxJWkVSYCBmdW5jdGlvbnMgYXJlIG5vdCBhd2FpdGVkLFxuICogaGVuY2UgdGhleSBzaG91bGQgbm90IGJlIGBhc3luY2AuXG4gKlxuICogQHB1YmxpY0FwaVxuICovXG5leHBvcnQgY29uc3QgRU5WSVJPTk1FTlRfSU5JVElBTElaRVIgPSBuZXcgSW5qZWN0aW9uVG9rZW48UmVhZG9ubHlBcnJheTwoKSA9PiB2b2lkPj4oXG4gIG5nRGV2TW9kZSA/ICdFTlZJUk9OTUVOVF9JTklUSUFMSVpFUicgOiAnJyxcbik7XG4iXX0=