/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { makeDecorator } from '../util/decorators';
import { compileInjectable } from './jit/injectable';
export { compileInjectable };
/**
 * Injectable decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Injectable = makeDecorator('Injectable', undefined, undefined, undefined, (type, meta) => compileInjectable(type, meta));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5qZWN0YWJsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvc3JjL2RpL2luamVjdGFibGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBR0gsT0FBTyxFQUFDLGFBQWEsRUFBZ0IsTUFBTSxvQkFBb0IsQ0FBQztBQVVoRSxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSxrQkFBa0IsQ0FBQztBQUVuRCxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsQ0FBQztBQTZFM0I7Ozs7O0dBS0c7QUFDSCxNQUFNLENBQUMsTUFBTSxVQUFVLEdBQXdCLGFBQWEsQ0FDMUQsWUFBWSxFQUNaLFNBQVMsRUFDVCxTQUFTLEVBQ1QsU0FBUyxFQUNULENBQUMsSUFBZSxFQUFFLElBQWdCLEVBQUUsRUFBRSxDQUFDLGlCQUFpQixDQUFDLElBQVcsRUFBRSxJQUFJLENBQUMsQ0FDNUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmRldi9saWNlbnNlXG4gKi9cblxuaW1wb3J0IHtUeXBlfSBmcm9tICcuLi9pbnRlcmZhY2UvdHlwZSc7XG5pbXBvcnQge21ha2VEZWNvcmF0b3IsIFR5cGVEZWNvcmF0b3J9IGZyb20gJy4uL3V0aWwvZGVjb3JhdG9ycyc7XG5cbmltcG9ydCB7XG4gIENsYXNzU2Fuc1Byb3ZpZGVyLFxuICBDb25zdHJ1Y3RvclNhbnNQcm92aWRlcixcbiAgRXhpc3RpbmdTYW5zUHJvdmlkZXIsXG4gIEZhY3RvcnlTYW5zUHJvdmlkZXIsXG4gIFN0YXRpY0NsYXNzU2Fuc1Byb3ZpZGVyLFxuICBWYWx1ZVNhbnNQcm92aWRlcixcbn0gZnJvbSAnLi9pbnRlcmZhY2UvcHJvdmlkZXInO1xuaW1wb3J0IHtjb21waWxlSW5qZWN0YWJsZX0gZnJvbSAnLi9qaXQvaW5qZWN0YWJsZSc7XG5cbmV4cG9ydCB7Y29tcGlsZUluamVjdGFibGV9O1xuXG4vKipcbiAqIEluamVjdGFibGUgcHJvdmlkZXJzIHVzZWQgaW4gYEBJbmplY3RhYmxlYCBkZWNvcmF0b3IuXG4gKlxuICogQHB1YmxpY0FwaVxuICovXG5leHBvcnQgdHlwZSBJbmplY3RhYmxlUHJvdmlkZXIgPVxuICB8IFZhbHVlU2Fuc1Byb3ZpZGVyXG4gIHwgRXhpc3RpbmdTYW5zUHJvdmlkZXJcbiAgfCBTdGF0aWNDbGFzc1NhbnNQcm92aWRlclxuICB8IENvbnN0cnVjdG9yU2Fuc1Byb3ZpZGVyXG4gIHwgRmFjdG9yeVNhbnNQcm92aWRlclxuICB8IENsYXNzU2Fuc1Byb3ZpZGVyO1xuXG4vKipcbiAqIFR5cGUgb2YgdGhlIEluamVjdGFibGUgZGVjb3JhdG9yIC8gY29uc3RydWN0b3IgZnVuY3Rpb24uXG4gKlxuICogQHB1YmxpY0FwaVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEluamVjdGFibGVEZWNvcmF0b3Ige1xuICAvKipcbiAgICogRGVjb3JhdG9yIHRoYXQgbWFya3MgYSBjbGFzcyBhcyBhdmFpbGFibGUgdG8gYmVcbiAgICogcHJvdmlkZWQgYW5kIGluamVjdGVkIGFzIGEgZGVwZW5kZW5jeS5cbiAgICpcbiAgICogQHNlZSBbSW50cm9kdWN0aW9uIHRvIFNlcnZpY2VzIGFuZCBESV0oZ3VpZGUvZGkpXG4gICAqIEBzZWUgW0RlcGVuZGVuY3kgSW5qZWN0aW9uIEd1aWRlXShndWlkZS9kaS9kZXBlbmRlbmN5LWluamVjdGlvblxuICAgKlxuICAgKiBAdXNhZ2VOb3Rlc1xuICAgKlxuICAgKiBNYXJraW5nIGEgY2xhc3Mgd2l0aCBgQEluamVjdGFibGVgIGVuc3VyZXMgdGhhdCB0aGUgY29tcGlsZXJcbiAgICogd2lsbCBnZW5lcmF0ZSB0aGUgbmVjZXNzYXJ5IG1ldGFkYXRhIHRvIGNyZWF0ZSB0aGUgY2xhc3Mnc1xuICAgKiBkZXBlbmRlbmNpZXMgd2hlbiB0aGUgY2xhc3MgaXMgaW5qZWN0ZWQuXG4gICAqXG4gICAqIFRoZSBmb2xsb3dpbmcgZXhhbXBsZSBzaG93cyBob3cgYSBzZXJ2aWNlIGNsYXNzIGlzIHByb3Blcmx5XG4gICAqICBtYXJrZWQgc28gdGhhdCBhIHN1cHBvcnRpbmcgc2VydmljZSBjYW4gYmUgaW5qZWN0ZWQgdXBvbiBjcmVhdGlvbi5cbiAgICpcbiAgICogPGNvZGUtZXhhbXBsZSBwYXRoPVwiY29yZS9kaS90cy9tZXRhZGF0YV9zcGVjLnRzXCIgcmVnaW9uPVwiSW5qZWN0YWJsZVwiPjwvY29kZS1leGFtcGxlPlxuICAgKlxuICAgKi9cbiAgKCk6IFR5cGVEZWNvcmF0b3I7XG4gIChcbiAgICBvcHRpb25zPzoge3Byb3ZpZGVkSW46IFR5cGU8YW55PiB8ICdyb290JyB8ICdwbGF0Zm9ybScgfCAnYW55JyB8IG51bGx9ICYgSW5qZWN0YWJsZVByb3ZpZGVyLFxuICApOiBUeXBlRGVjb3JhdG9yO1xuICBuZXcgKCk6IEluamVjdGFibGU7XG4gIG5ldyAoXG4gICAgb3B0aW9ucz86IHtwcm92aWRlZEluOiBUeXBlPGFueT4gfCAncm9vdCcgfCAncGxhdGZvcm0nIHwgJ2FueScgfCBudWxsfSAmIEluamVjdGFibGVQcm92aWRlcixcbiAgKTogSW5qZWN0YWJsZTtcbn1cblxuLyoqXG4gKiBUeXBlIG9mIHRoZSBJbmplY3RhYmxlIG1ldGFkYXRhLlxuICpcbiAqIEBwdWJsaWNBcGlcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJbmplY3RhYmxlIHtcbiAgLyoqXG4gICAqIERldGVybWluZXMgd2hpY2ggaW5qZWN0b3JzIHdpbGwgcHJvdmlkZSB0aGUgaW5qZWN0YWJsZS5cbiAgICpcbiAgICogLSBgVHlwZTxhbnk+YCAtIGFzc29jaWF0ZXMgdGhlIGluamVjdGFibGUgd2l0aCBhbiBgQE5nTW9kdWxlYCBvciBvdGhlciBgSW5qZWN0b3JUeXBlYC4gVGhpc1xuICAgKiBvcHRpb24gaXMgREVQUkVDQVRFRC5cbiAgICogLSAnbnVsbCcgOiBFcXVpdmFsZW50IHRvIGB1bmRlZmluZWRgLiBUaGUgaW5qZWN0YWJsZSBpcyBub3QgcHJvdmlkZWQgaW4gYW55IHNjb3BlIGF1dG9tYXRpY2FsbHlcbiAgICogYW5kIG11c3QgYmUgYWRkZWQgdG8gYSBgcHJvdmlkZXJzYCBhcnJheSBvZiBhbiBbQE5nTW9kdWxlXShhcGkvY29yZS9OZ01vZHVsZSNwcm92aWRlcnMpLFxuICAgKiBbQENvbXBvbmVudF0oYXBpL2NvcmUvRGlyZWN0aXZlI3Byb3ZpZGVycykgb3IgW0BEaXJlY3RpdmVdKGFwaS9jb3JlL0RpcmVjdGl2ZSNwcm92aWRlcnMpLlxuICAgKlxuICAgKiBUaGUgZm9sbG93aW5nIG9wdGlvbnMgc3BlY2lmeSB0aGF0IHRoaXMgaW5qZWN0YWJsZSBzaG91bGQgYmUgcHJvdmlkZWQgaW4gb25lIG9mIHRoZSBmb2xsb3dpbmdcbiAgICogaW5qZWN0b3JzOlxuICAgKiAtICdyb290JyA6IFRoZSBhcHBsaWNhdGlvbi1sZXZlbCBpbmplY3RvciBpbiBtb3N0IGFwcHMuXG4gICAqIC0gJ3BsYXRmb3JtJyA6IEEgc3BlY2lhbCBzaW5nbGV0b24gcGxhdGZvcm0gaW5qZWN0b3Igc2hhcmVkIGJ5IGFsbFxuICAgKiBhcHBsaWNhdGlvbnMgb24gdGhlIHBhZ2UuXG4gICAqIC0gJ2FueScgOiBQcm92aWRlcyBhIHVuaXF1ZSBpbnN0YW5jZSBpbiBlYWNoIGxhenkgbG9hZGVkIG1vZHVsZSB3aGlsZSBhbGwgZWFnZXJseSBsb2FkZWRcbiAgICogbW9kdWxlcyBzaGFyZSBvbmUgaW5zdGFuY2UuIFRoaXMgb3B0aW9uIGlzIERFUFJFQ0FURUQuXG4gICAqXG4gICAqL1xuICBwcm92aWRlZEluPzogVHlwZTxhbnk+IHwgJ3Jvb3QnIHwgJ3BsYXRmb3JtJyB8ICdhbnknIHwgbnVsbDtcbn1cblxuLyoqXG4gKiBJbmplY3RhYmxlIGRlY29yYXRvciBhbmQgbWV0YWRhdGEuXG4gKlxuICogQEFubm90YXRpb25cbiAqIEBwdWJsaWNBcGlcbiAqL1xuZXhwb3J0IGNvbnN0IEluamVjdGFibGU6IEluamVjdGFibGVEZWNvcmF0b3IgPSBtYWtlRGVjb3JhdG9yKFxuICAnSW5qZWN0YWJsZScsXG4gIHVuZGVmaW5lZCxcbiAgdW5kZWZpbmVkLFxuICB1bmRlZmluZWQsXG4gICh0eXBlOiBUeXBlPGFueT4sIG1ldGE6IEluamVjdGFibGUpID0+IGNvbXBpbGVJbmplY3RhYmxlKHR5cGUgYXMgYW55LCBtZXRhKSxcbik7XG4iXX0=