/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { makeParamDecorator } from '../util/decorators';
import { attachInjectFlag } from './injector_compatibility';
/**
 * Inject decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Inject = attachInjectFlag(
// Disable tslint because `DecoratorFlags` is a const enum which gets inlined.
makeParamDecorator('Inject', (token) => ({ token })), -1 /* DecoratorFlags.Inject */);
/**
 * Optional decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Optional = 
// Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
attachInjectFlag(makeParamDecorator('Optional'), 8 /* InternalInjectFlags.Optional */);
/**
 * Self decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Self = 
// Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
attachInjectFlag(makeParamDecorator('Self'), 2 /* InternalInjectFlags.Self */);
/**
 * `SkipSelf` decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const SkipSelf = 
// Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
attachInjectFlag(makeParamDecorator('SkipSelf'), 4 /* InternalInjectFlags.SkipSelf */);
/**
 * Host decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Host = 
// Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
attachInjectFlag(makeParamDecorator('Host'), 1 /* InternalInjectFlags.Host */);
//# sourceMappingURL=data:application/json;base64,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