/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { Attribute } from '@angular/core/primitives/event-dispatch';
import { InjectionToken } from './di';
export function invokeRegisteredListeners(event) {
    const handlerFns = event.currentTarget?.__jsaction_fns?.get(event.type);
    if (!handlerFns) {
        return;
    }
    for (const handler of handlerFns) {
        handler(event);
    }
}
export function setJSActionAttributes(nativeElement, eventTypes) {
    if (!eventTypes.length) {
        return;
    }
    const parts = eventTypes.reduce((prev, curr) => prev + curr + ':;', '');
    const existingAttr = nativeElement.getAttribute(Attribute.JSACTION);
    nativeElement.setAttribute(Attribute.JSACTION, `${existingAttr ?? ''}${parts}`);
}
export const sharedStashFunction = (rEl, eventType, listenerFn) => {
    const el = rEl;
    const eventListenerMap = el.__jsaction_fns ?? new Map();
    const eventListeners = eventListenerMap.get(eventType) ?? [];
    eventListeners.push(listenerFn);
    eventListenerMap.set(eventType, eventListeners);
    el.__jsaction_fns = eventListenerMap;
};
export const removeListeners = (el) => {
    el.removeAttribute(Attribute.JSACTION);
    el.__jsaction_fns = undefined;
};
export const JSACTION_EVENT_CONTRACT = new InjectionToken(ngDevMode ? 'EVENT_CONTRACT_DETAILS' : '', {
    providedIn: 'root',
    factory: () => ({}),
});
//# sourceMappingURL=data:application/json;base64,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