/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/** Encodes that the node lookup should start from the host node of this component. */
export const REFERENCE_NODE_HOST = 'h';
/** Encodes that the node lookup should start from the document body node. */
export const REFERENCE_NODE_BODY = 'b';
/**
 * Describes navigation steps that the runtime logic need to perform,
 * starting from a given (known) element.
 */
export var NodeNavigationStep;
(function (NodeNavigationStep) {
    NodeNavigationStep["FirstChild"] = "f";
    NodeNavigationStep["NextSibling"] = "n";
})(NodeNavigationStep || (NodeNavigationStep = {}));
/**
 * Keys within serialized view data structure to represent various
 * parts. See the `SerializedView` interface below for additional information.
 */
export const ELEMENT_CONTAINERS = 'e';
export const TEMPLATES = 't';
export const CONTAINERS = 'c';
export const MULTIPLIER = 'x';
export const NUM_ROOT_NODES = 'r';
export const TEMPLATE_ID = 'i'; // as it's also an "id"
export const NODES = 'n';
export const DISCONNECTED_NODES = 'd';
export const I18N_DATA = 'l';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZXJmYWNlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvc3JjL2h5ZHJhdGlvbi9pbnRlcmZhY2VzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQUtILHNGQUFzRjtBQUN0RixNQUFNLENBQUMsTUFBTSxtQkFBbUIsR0FBRyxHQUFHLENBQUM7QUFFdkMsNkVBQTZFO0FBQzdFLE1BQU0sQ0FBQyxNQUFNLG1CQUFtQixHQUFHLEdBQUcsQ0FBQztBQUV2Qzs7O0dBR0c7QUFDSCxNQUFNLENBQU4sSUFBWSxrQkFHWDtBQUhELFdBQVksa0JBQWtCO0lBQzVCLHNDQUFnQixDQUFBO0lBQ2hCLHVDQUFpQixDQUFBO0FBQ25CLENBQUMsRUFIVyxrQkFBa0IsS0FBbEIsa0JBQWtCLFFBRzdCO0FBRUQ7OztHQUdHO0FBQ0gsTUFBTSxDQUFDLE1BQU0sa0JBQWtCLEdBQUcsR0FBRyxDQUFDO0FBQ3RDLE1BQU0sQ0FBQyxNQUFNLFNBQVMsR0FBRyxHQUFHLENBQUM7QUFDN0IsTUFBTSxDQUFDLE1BQU0sVUFBVSxHQUFHLEdBQUcsQ0FBQztBQUM5QixNQUFNLENBQUMsTUFBTSxVQUFVLEdBQUcsR0FBRyxDQUFDO0FBQzlCLE1BQU0sQ0FBQyxNQUFNLGNBQWMsR0FBRyxHQUFHLENBQUM7QUFDbEMsTUFBTSxDQUFDLE1BQU0sV0FBVyxHQUFHLEdBQUcsQ0FBQyxDQUFDLHVCQUF1QjtBQUN2RCxNQUFNLENBQUMsTUFBTSxLQUFLLEdBQUcsR0FBRyxDQUFDO0FBQ3pCLE1BQU0sQ0FBQyxNQUFNLGtCQUFrQixHQUFHLEdBQUcsQ0FBQztBQUN0QyxNQUFNLENBQUMsTUFBTSxTQUFTLEdBQUcsR0FBRyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuZGV2L2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQgdHlwZSB7STE4bklDVU5vZGV9IGZyb20gJy4uL3JlbmRlcjMvaW50ZXJmYWNlcy9pMThuJztcbmltcG9ydCB7Uk5vZGV9IGZyb20gJy4uL3JlbmRlcjMvaW50ZXJmYWNlcy9yZW5kZXJlcl9kb20nO1xuXG4vKiogRW5jb2RlcyB0aGF0IHRoZSBub2RlIGxvb2t1cCBzaG91bGQgc3RhcnQgZnJvbSB0aGUgaG9zdCBub2RlIG9mIHRoaXMgY29tcG9uZW50LiAqL1xuZXhwb3J0IGNvbnN0IFJFRkVSRU5DRV9OT0RFX0hPU1QgPSAnaCc7XG5cbi8qKiBFbmNvZGVzIHRoYXQgdGhlIG5vZGUgbG9va3VwIHNob3VsZCBzdGFydCBmcm9tIHRoZSBkb2N1bWVudCBib2R5IG5vZGUuICovXG5leHBvcnQgY29uc3QgUkVGRVJFTkNFX05PREVfQk9EWSA9ICdiJztcblxuLyoqXG4gKiBEZXNjcmliZXMgbmF2aWdhdGlvbiBzdGVwcyB0aGF0IHRoZSBydW50aW1lIGxvZ2ljIG5lZWQgdG8gcGVyZm9ybSxcbiAqIHN0YXJ0aW5nIGZyb20gYSBnaXZlbiAoa25vd24pIGVsZW1lbnQuXG4gKi9cbmV4cG9ydCBlbnVtIE5vZGVOYXZpZ2F0aW9uU3RlcCB7XG4gIEZpcnN0Q2hpbGQgPSAnZicsXG4gIE5leHRTaWJsaW5nID0gJ24nLFxufVxuXG4vKipcbiAqIEtleXMgd2l0aGluIHNlcmlhbGl6ZWQgdmlldyBkYXRhIHN0cnVjdHVyZSB0byByZXByZXNlbnQgdmFyaW91c1xuICogcGFydHMuIFNlZSB0aGUgYFNlcmlhbGl6ZWRWaWV3YCBpbnRlcmZhY2UgYmVsb3cgZm9yIGFkZGl0aW9uYWwgaW5mb3JtYXRpb24uXG4gKi9cbmV4cG9ydCBjb25zdCBFTEVNRU5UX0NPTlRBSU5FUlMgPSAnZSc7XG5leHBvcnQgY29uc3QgVEVNUExBVEVTID0gJ3QnO1xuZXhwb3J0IGNvbnN0IENPTlRBSU5FUlMgPSAnYyc7XG5leHBvcnQgY29uc3QgTVVMVElQTElFUiA9ICd4JztcbmV4cG9ydCBjb25zdCBOVU1fUk9PVF9OT0RFUyA9ICdyJztcbmV4cG9ydCBjb25zdCBURU1QTEFURV9JRCA9ICdpJzsgLy8gYXMgaXQncyBhbHNvIGFuIFwiaWRcIlxuZXhwb3J0IGNvbnN0IE5PREVTID0gJ24nO1xuZXhwb3J0IGNvbnN0IERJU0NPTk5FQ1RFRF9OT0RFUyA9ICdkJztcbmV4cG9ydCBjb25zdCBJMThOX0RBVEEgPSAnbCc7XG5cbi8qKlxuICogUmVwcmVzZW50cyBlbGVtZW50IGNvbnRhaW5lcnMgd2l0aGluIHRoaXMgdmlldywgc3RvcmVkIGFzIGtleS12YWx1ZSBwYWlyc1xuICogd2hlcmUga2V5IGlzIGFuIGluZGV4IG9mIGEgY29udGFpbmVyIGluIGFuIExWaWV3IChhbHNvIHVzZWQgaW4gdGhlXG4gKiBgZWxlbWVudENvbnRhaW5lclN0YXJ0YCBpbnN0cnVjdGlvbiksIHRoZSB2YWx1ZSBpcyB0aGUgbnVtYmVyIG9mIHJvb3Qgbm9kZXNcbiAqIGluIHRoaXMgY29udGFpbmVyLiBUaGlzIGluZm9ybWF0aW9uIGlzIG5lZWRlZCB0byBsb2NhdGUgYW4gYW5jaG9yIGNvbW1lbnRcbiAqIG5vZGUgdGhhdCBnb2VzIGFmdGVyIGFsbCBjb250YWluZXIgbm9kZXMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU2VyaWFsaXplZEVsZW1lbnRDb250YWluZXJzIHtcbiAgW2tleTogbnVtYmVyXTogbnVtYmVyO1xufVxuXG4vKipcbiAqIFNlcmlhbGl6ZWQgZGF0YSBzdHJ1Y3R1cmUgdGhhdCBjb250YWlucyByZWxldmFudCBoeWRyYXRpb25cbiAqIGFubm90YXRpb24gaW5mb3JtYXRpb24gdGhhdCBkZXNjcmliZXMgYSBnaXZlbiBoeWRyYXRpb24gYm91bmRhcnlcbiAqIChlLmcuIGEgY29tcG9uZW50KS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZXJpYWxpemVkVmlldyB7XG4gIC8qKlxuICAgKiBTZXJpYWxpemVkIGluZm9ybWF0aW9uIGFib3V0IDxuZy1jb250YWluZXI+cy5cbiAgICovXG4gIFtFTEVNRU5UX0NPTlRBSU5FUlNdPzogU2VyaWFsaXplZEVsZW1lbnRDb250YWluZXJzO1xuXG4gIC8qKlxuICAgKiBTZXJpYWxpemVkIGluZm9ybWF0aW9uIGFib3V0IHRlbXBsYXRlcy5cbiAgICogS2V5LXZhbHVlIHBhaXJzIHdoZXJlIGEga2V5IGlzIGFuIGluZGV4IG9mIHRoZSBjb3JyZXNwb25kaW5nXG4gICAqIGB0ZW1wbGF0ZWAgaW5zdHJ1Y3Rpb24gYW5kIHRoZSB2YWx1ZSBpcyBhIHVuaXF1ZSBpZCB0aGF0IGNhblxuICAgKiBiZSB1c2VkIGR1cmluZyBoeWRyYXRpb24gdG8gaWRlbnRpZnkgdGhhdCB0ZW1wbGF0ZS5cbiAgICovXG4gIFtURU1QTEFURVNdPzogUmVjb3JkPG51bWJlciwgc3RyaW5nPjtcblxuICAvKipcbiAgICogU2VyaWFsaXplZCBpbmZvcm1hdGlvbiBhYm91dCB2aWV3IGNvbnRhaW5lcnMuXG4gICAqIEtleS12YWx1ZSBwYWlycyB3aGVyZSBhIGtleSBpcyBhbiBpbmRleCBvZiB0aGUgY29ycmVzcG9uZGluZ1xuICAgKiBMQ29udGFpbmVyIGVudHJ5IHdpdGhpbiBhbiBMVmlldywgYW5kIHRoZSB2YWx1ZSBpcyBhIGxpc3RcbiAgICogb2Ygc2VyaWFsaXplZCBpbmZvcm1hdGlvbiBhYm91dCB2aWV3cyB3aXRoaW4gdGhpcyBjb250YWluZXIuXG4gICAqL1xuICBbQ09OVEFJTkVSU10/OiBSZWNvcmQ8bnVtYmVyLCBTZXJpYWxpemVkQ29udGFpbmVyVmlld1tdPjtcblxuICAvKipcbiAgICogU2VyaWFsaXplZCBpbmZvcm1hdGlvbiBhYm91dCBub2RlcyBpbiBhIHRlbXBsYXRlLlxuICAgKiBLZXktdmFsdWUgcGFpcnMgd2hlcmUgYSBrZXkgaXMgYW4gaW5kZXggb2YgdGhlIGNvcnJlc3BvbmRpbmdcbiAgICogRE9NIG5vZGUgaW4gYW4gTFZpZXcgYW5kIHRoZSB2YWx1ZSBpcyBhIHBhdGggdGhhdCBkZXNjcmliZXNcbiAgICogdGhlIGxvY2F0aW9uIG9mIHRoaXMgbm9kZSAoYXMgYSBzZXQgb2YgbmF2aWdhdGlvbiBpbnN0cnVjdGlvbnMpLlxuICAgKi9cbiAgW05PREVTXT86IFJlY29yZDxudW1iZXIsIHN0cmluZz47XG5cbiAgLyoqXG4gICAqIEEgbGlzdCBvZiBpZHMgd2hpY2ggcmVwcmVzZW50cyBhIHNldCBvZiBub2RlcyBkaXNjb25uZWN0ZWRcbiAgICogZnJvbSB0aGUgRE9NIHRyZWUgYXQgdGhlIHNlcmlhbGl6YXRpb24gdGltZSwgYnV0IG90aGVyd2lzZVxuICAgKiBwcmVzZW50IGluIHRoZSBpbnRlcm5hbCBkYXRhIHN0cnVjdHVyZXMuXG4gICAqXG4gICAqIFRoaXMgaW5mb3JtYXRpb24gaXMgdXNlZCB0byBhdm9pZCB0cmlnZ2VyaW5nIHRoZSBoeWRyYXRpb25cbiAgICogbG9naWMgZm9yIHN1Y2ggbm9kZXMgYW5kIGluc3RlYWQgdXNlIGEgcmVndWxhciBcImNyZWF0aW9uIG1vZGVcIi5cbiAgICovXG4gIFtESVNDT05ORUNURURfTk9ERVNdPzogbnVtYmVyW107XG5cbiAgLyoqXG4gICAqIFNlcmlhbGl6ZWQgaW5mb3JtYXRpb24gYWJvdXQgaTE4biBibG9ja3MgaW4gYSB0ZW1wbGF0ZS5cbiAgICogS2V5LXZhbHVlIHBhaXJzIHdoZXJlIGEga2V5IGlzIGFuIGluZGV4IG9mIHRoZSBjb3JyZXNwb25kaW5nXG4gICAqIGkxOG4gZW50cnkgd2l0aGluIGFuIExWaWV3LCBhbmQgdGhlIHZhbHVlIGlzIGEgbGlzdCBvZlxuICAgKiBhY3RpdmUgSUNVIGNhc2VzLlxuICAgKi9cbiAgW0kxOE5fREFUQV0/OiBSZWNvcmQ8bnVtYmVyLCBudW1iZXJbXT47XG59XG5cbi8qKlxuICogU2VyaWFsaXplZCBkYXRhIHN0cnVjdHVyZSB0aGF0IGNvbnRhaW5zIHJlbGV2YW50IGh5ZHJhdGlvblxuICogYW5ub3RhdGlvbiBpbmZvcm1hdGlvbiBhYm91dCBhIHZpZXcgdGhhdCBpcyBhIHBhcnQgb2YgYVxuICogVmlld0NvbnRhaW5lciBjb2xsZWN0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNlcmlhbGl6ZWRDb250YWluZXJWaWV3IGV4dGVuZHMgU2VyaWFsaXplZFZpZXcge1xuICAvKipcbiAgICogVW5pcXVlIGlkIHRoYXQgcmVwcmVzZW50cyBhIFRWaWV3IHRoYXQgd2FzIHVzZWQgdG8gY3JlYXRlXG4gICAqIGEgZ2l2ZW4gaW5zdGFuY2Ugb2YgYSB2aWV3OlxuICAgKiAgLSBUVmlld1R5cGUuRW1iZWRkZWQ6IGEgdW5pcXVlIGlkIGdlbmVyYXRlZCBkdXJpbmcgc2VyaWFsaXphdGlvbiBvbiB0aGUgc2VydmVyXG4gICAqICAtIFRWaWV3VHlwZS5Db21wb25lbnQ6IGFuIGlkIGdlbmVyYXRlZCBiYXNlZCBvbiBjb21wb25lbnQgcHJvcGVydGllc1xuICAgKiAgICAgICAgICAgICAgICAgICAgICAgIChzZWUgYGdldENvbXBvbmVudElkYCBmdW5jdGlvbiBmb3IgZGV0YWlscylcbiAgICovXG4gIFtURU1QTEFURV9JRF06IHN0cmluZztcblxuICAvKipcbiAgICogTnVtYmVyIG9mIHJvb3Qgbm9kZXMgdGhhdCBiZWxvbmcgdG8gdGhpcyB2aWV3LlxuICAgKiBUaGlzIGluZm9ybWF0aW9uIGlzIG5lZWRlZCB0byBlZmZlY3RpdmVseSB0cmF2ZXJzZSB0aGUgRE9NIHRyZWVcbiAgICogYW5kIGlkZW50aWZ5IHNlZ21lbnRzIHRoYXQgYmVsb25nIHRvIGRpZmZlcmVudCB2aWV3cy5cbiAgICovXG4gIFtOVU1fUk9PVF9OT0RFU106IG51bWJlcjtcblxuICAvKipcbiAgICogTnVtYmVyIG9mIHRpbWVzIHRoaXMgdmlldyBpcyByZXBlYXRlZC5cbiAgICogVGhpcyBpcyB1c2VkIHRvIGF2b2lkIHNlcmlhbGl6aW5nIGFuZCBzZW5kaW5nIHRoZSBzYW1lIGh5ZHJhdGlvblxuICAgKiBpbmZvcm1hdGlvbiBhYm91dCBzaW1pbGFyIHZpZXdzIChmb3IgZXhhbXBsZSwgcHJvZHVjZWQgYnkgKm5nRm9yKS5cbiAgICovXG4gIFtNVUxUSVBMSUVSXT86IG51bWJlcjtcbn1cblxuLyoqXG4gKiBBbiBvYmplY3QgdGhhdCBjb250YWlucyBoeWRyYXRpb24tcmVsYXRlZCBpbmZvcm1hdGlvbiBzZXJpYWxpemVkXG4gKiBvbiB0aGUgc2VydmVyLCBhcyB3ZWxsIGFzIHRoZSBuZWNlc3NhcnkgcmVmZXJlbmNlcyB0byBzZWdtZW50cyBvZlxuICogdGhlIERPTSwgdG8gZmFjaWxpdGF0ZSB0aGUgaHlkcmF0aW9uIHByb2Nlc3MgZm9yIGEgZ2l2ZW4gaHlkcmF0aW9uXG4gKiBib3VuZGFyeSBvbiB0aGUgY2xpZW50LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIERlaHlkcmF0ZWRWaWV3IHtcbiAgLyoqXG4gICAqIFRoZSByZWFkb25seSBoeWRyYXRpb24gYW5ub3RhdGlvbiBkYXRhLlxuICAgKi9cbiAgZGF0YTogUmVhZG9ubHk8U2VyaWFsaXplZFZpZXc+O1xuXG4gIC8qKlxuICAgKiBBIHJlZmVyZW5jZSB0byB0aGUgZmlyc3QgY2hpbGQgaW4gYSBET00gc2VnbWVudCBhc3NvY2lhdGVkXG4gICAqIHdpdGggYSBnaXZlbiBoeWRyYXRpb24gYm91bmRhcnkuXG4gICAqXG4gICAqIE9uY2UgYSB2aWV3IGJlY29tZXMgaHlkcmF0ZWQsIHRoZSB2YWx1ZSBpcyBzZXQgdG8gYG51bGxgLCB3aGljaFxuICAgKiBpbmRpY2F0ZXMgdGhhdCBmdXJ0aGVyIGRldGFjaGluZy9hdHRhY2hpbmcgdmlldyBhY3Rpb25zIHNob3VsZCByZXN1bHRcbiAgICogaW4gaW52b2tpbmcgY29ycmVzcG9uZGluZyBET00gYWN0aW9ucyAoYXR0YWNoaW5nIERPTSBub2RlcyBhY3Rpb24gaXNcbiAgICogc2tpcHBlZCB3aGVuIHdlIGh5ZHJhdGUsIHNpbmNlIG5vZGVzIGFyZSBhbHJlYWR5IGluIHRoZSBET00pLlxuICAgKi9cbiAgZmlyc3RDaGlsZDogUk5vZGUgfCBudWxsO1xuXG4gIC8qKlxuICAgKiBTdG9yZXMgcmVmZXJlbmNlcyB0byBmaXJzdCBub2RlcyBpbiBET00gc2VnbWVudHMgdGhhdFxuICAgKiByZXByZXNlbnQgZWl0aGVyIGFuIDxuZy1jb250YWluZXI+IG9yIGEgdmlldyBjb250YWluZXIuXG4gICAqL1xuICBzZWdtZW50SGVhZHM/OiB7W2luZGV4OiBudW1iZXJdOiBSTm9kZSB8IG51bGx9O1xuXG4gIC8qKlxuICAgKiBBbiBpbnN0YW5jZSBvZiBhIFNldCB0aGF0IHJlcHJlc2VudHMgbm9kZXMgZGlzY29ubmVjdGVkIGZyb21cbiAgICogdGhlIERPTSB0cmVlIGF0IHRoZSBzZXJpYWxpemF0aW9uIHRpbWUsIGJ1dCBvdGhlcndpc2UgcHJlc2VudFxuICAgKiBpbiB0aGUgaW50ZXJuYWwgZGF0YSBzdHJ1Y3R1cmVzLlxuICAgKlxuICAgKiBUaGUgU2V0IGlzIGJhc2VkIG9uIHRoZSBgU2VyaWFsaXplZFZpZXdbRElTQ09OTkVDVEVEX05PREVTXWAgZGF0YVxuICAgKiBhbmQgaXMgbmVlZGVkIHRvIGhhdmUgY29uc3RhbnQtdGltZSBsb29rdXBzLlxuICAgKlxuICAgKiBJZiB0aGUgdmFsdWUgaXMgYG51bGxgLCBpdCBtZWFucyB0aGF0IHRoZXJlIHdlcmUgbm8gZGlzY29ubmVjdGVkXG4gICAqIG5vZGVzIGRldGVjdGVkIGluIHRoaXMgdmlldyBhdCBzZXJpYWxpemF0aW9uIHRpbWUuXG4gICAqL1xuICBkaXNjb25uZWN0ZWROb2Rlcz86IFNldDxudW1iZXI+IHwgbnVsbDtcblxuICAvKipcbiAgICogQSBtYXBwaW5nIGZyb20gYSB2aWV3IHRvIHRoZSBmaXJzdCBjaGlsZCB0byBiZWdpbiBjbGFpbWluZyBub2Rlcy5cbiAgICpcbiAgICogVGhpcyBtYXBwaW5nIGlzIGdlbmVyYXRlZCBieSBhbiBpMThuIGJsb2NrLCBhbmQgaXMgdGhlIHNvdXJjZSBvZlxuICAgKiB0cnV0aCBmb3IgdGhlIG5vZGVzIGluc2lkZSBvZiBpdC5cbiAgICovXG4gIGkxOG5Ob2Rlcz86IE1hcDxudW1iZXIsIFJOb2RlIHwgbnVsbD47XG5cbiAgLyoqXG4gICAqIEEgbWFwcGluZyBmcm9tIHRoZSBpbmRleCBvZiBhbiBJQ1Ugbm9kZSB0byBkZWh5ZHJhdGVkIGRhdGEgZm9yIGl0LlxuICAgKlxuICAgKiBUaGlzIGluZm9ybWF0aW9uIGlzIHVzZWQgZHVyaW5nIHRoZSBoeWRyYXRpb24gcHJvY2VzcyBvbiB0aGUgY2xpZW50LlxuICAgKiBJQ1UgY2FzZXMgdGhhdCB3ZXJlIGFjdGl2ZSBkdXJpbmcgc2VydmVyLXNpZGUgcmVuZGVyaW5nIHdpbGwgYmUgYWRkZWRcbiAgICogdG8gdGhlIG1hcC4gVGhlIGh5ZHJhdGlvbiBsb2dpYyB3aWxsIFwiY2xhaW1cIiBtYXRjaGluZyBjYXNlcywgcmVtb3ZpbmdcbiAgICogdGhlbSBmcm9tIHRoZSBtYXAuIFRoZSByZW1haW5pbmcgZW50cmllcyBhcmUgXCJ1bmNsYWltZWRcIiwgYW5kIHdpbGwgYmVcbiAgICogcmVtb3ZlZCBmcm9tIHRoZSBET00gZHVyaW5nIGh5ZHJhdGlvbiBjbGVhbnVwLlxuICAgKi9cbiAgZGVoeWRyYXRlZEljdURhdGE/OiBNYXA8bnVtYmVyLCBEZWh5ZHJhdGVkSWN1RGF0YT47XG59XG5cbi8qKlxuICogQW4gb2JqZWN0IHRoYXQgY29udGFpbnMgaHlkcmF0aW9uLXJlbGF0ZWQgaW5mb3JtYXRpb24gc2VyaWFsaXplZFxuICogb24gdGhlIHNlcnZlciwgYXMgd2VsbCBhcyB0aGUgbmVjZXNzYXJ5IHJlZmVyZW5jZXMgdG8gc2VnbWVudHMgb2ZcbiAqIHRoZSBET00sIHRvIGZhY2lsaXRhdGUgdGhlIGh5ZHJhdGlvbiBwcm9jZXNzIGZvciBhIGdpdmVuIHZpZXdcbiAqIGluc2lkZSBhIHZpZXcgY29udGFpbmVyIChlaXRoZXIgYW4gZW1iZWRkZWQgdmlldyBvciBhIHZpZXcgY3JlYXRlZFxuICogZm9yIGEgY29tcG9uZW50KS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEZWh5ZHJhdGVkQ29udGFpbmVyVmlldyBleHRlbmRzIERlaHlkcmF0ZWRWaWV3IHtcbiAgZGF0YTogUmVhZG9ubHk8U2VyaWFsaXplZENvbnRhaW5lclZpZXc+O1xufVxuXG4vKipcbiAqIEFuIG9iamVjdCB0aGF0IGNvbnRhaW5zIGluZm9ybWF0aW9uIGFib3V0IGEgZGVoeWRyYXRlZCBJQ1UgY2FzZSxcbiAqIHRvIGZhY2lsaXRhdGUgY2xlYW5pbmcgdXAgSUNVIGNhc2VzIHRoYXQgd2VyZSBhY3RpdmUgZHVyaW5nXG4gKiBzZXJ2ZXItc2lkZSByZW5kZXJpbmcsIGJ1dCBub3QgZHVyaW5nIGh5ZHJhdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEZWh5ZHJhdGVkSWN1RGF0YSB7XG4gIC8qKlxuICAgKiBUaGUgY2FzZSBpbmRleCB0aGF0IHRoaXMgZGF0YSByZXByZXNlbnRzLlxuICAgKi9cbiAgY2FzZTogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBBIHJlZmVyZW5jZSBiYWNrIHRvIHRoZSBBU1QgZm9yIHRoZSBJQ1Ugbm9kZS4gVGhpcyBhbGxvd3MgdGhlXG4gICAqIEFTVCB0byBiZSB1c2VkIHRvIGNsZWFuIHVwIGRlaHlkcmF0ZWQgbm9kZXMuXG4gICAqL1xuICBub2RlOiBJMThuSUNVTm9kZTtcbn1cbiJdfQ==