/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { InjectionToken } from '../di/injection_token';
/**
 * Internal token that specifies whether DOM reuse logic
 * during hydration is enabled.
 */
export const IS_HYDRATION_DOM_REUSE_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'IS_HYDRATION_DOM_REUSE_ENABLED' : '');
// By default (in client rendering mode), we remove all the contents
// of the host element and render an application after that.
export const PRESERVE_HOST_CONTENT_DEFAULT = false;
/**
 * Internal token that indicates whether host element content should be
 * retained during the bootstrap.
 */
export const PRESERVE_HOST_CONTENT = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'PRESERVE_HOST_CONTENT' : '', {
    providedIn: 'root',
    factory: () => PRESERVE_HOST_CONTENT_DEFAULT,
});
/**
 * Internal token that indicates whether hydration support for i18n
 * is enabled.
 */
export const IS_I18N_HYDRATION_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'IS_I18N_HYDRATION_ENABLED' : '');
/**
 * Internal token that indicates whether event replay support for SSR
 * is enabled.
 */
export const IS_EVENT_REPLAY_ENABLED = new InjectionToken(typeof ngDevMode === 'undefined' || !!ngDevMode ? 'IS_EVENT_REPLAY_ENABLED' : '');
export const EVENT_REPLAY_ENABLED_DEFAULT = false;
//# sourceMappingURL=data:application/json;base64,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