/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { getLView } from '../render3/state';
import { removeLViewOnDestroy, storeLViewOnDestroy } from '../render3/util/view_utils';
/**
 * `DestroyRef` lets you set callbacks to run for any cleanup or destruction behavior.
 * The scope of this destruction depends on where `DestroyRef` is injected. If `DestroyRef`
 * is injected in a component or directive, the callbacks run when that component or
 * directive is destroyed. Otherwise the callbacks run when a corresponding injector is destroyed.
 *
 * @publicApi
 */
export class DestroyRef {
    /**
     * @internal
     * @nocollapse
     */
    static { this.__NG_ELEMENT_ID__ = injectDestroyRef; }
    /**
     * @internal
     * @nocollapse
     */
    static { this.__NG_ENV_ID__ = (injector) => injector; }
}
class NodeInjectorDestroyRef extends DestroyRef {
    constructor(_lView) {
        super();
        this._lView = _lView;
    }
    onDestroy(callback) {
        storeLViewOnDestroy(this._lView, callback);
        return () => removeLViewOnDestroy(this._lView, callback);
    }
}
function injectDestroyRef() {
    return new NodeInjectorDestroyRef(getLView());
}
//# sourceMappingURL=data:application/json;base64,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