/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/**
 * Defines a schema that allows an NgModule to contain the following:
 * - Non-Angular elements named with dash case (`-`).
 * - Element properties named with dash case (`-`).
 * Dash case is the naming convention for custom elements.
 *
 * @publicApi
 */
export const CUSTOM_ELEMENTS_SCHEMA = {
    name: 'custom-elements',
};
/**
 * Defines a schema that allows any property on any element.
 *
 * This schema allows you to ignore the errors related to any unknown elements or properties in a
 * template. The usage of this schema is generally discouraged because it prevents useful validation
 * and may hide real errors in your template. Consider using the `CUSTOM_ELEMENTS_SCHEMA` instead.
 *
 * @publicApi
 */
export const NO_ERRORS_SCHEMA = {
    name: 'no-errors-schema',
};
//# sourceMappingURL=data:application/json;base64,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