/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { stringify } from '../util/stringify';
import { NG_FACTORY_DEF } from './fields';
export function getFactoryDef(type, throwNotFound) {
    const hasFactoryDef = type.hasOwnProperty(NG_FACTORY_DEF);
    if (!hasFactoryDef && throwNotFound === true && ngDevMode) {
        throw new Error(`Type ${stringify(type)} does not have 'ɵfac' property.`);
    }
    return hasFactoryDef ? type[NG_FACTORY_DEF] : null;
}
//# sourceMappingURL=data:application/json;base64,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