/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { getClosureSafeProperty } from '../util/property';
export const NG_COMP_DEF = getClosureSafeProperty({ ɵcmp: getClosureSafeProperty });
export const NG_DIR_DEF = getClosureSafeProperty({ ɵdir: getClosureSafeProperty });
export const NG_PIPE_DEF = getClosureSafeProperty({ ɵpipe: getClosureSafeProperty });
export const NG_MOD_DEF = getClosureSafeProperty({ ɵmod: getClosureSafeProperty });
export const NG_FACTORY_DEF = getClosureSafeProperty({ ɵfac: getClosureSafeProperty });
/**
 * If a directive is diPublic, bloomAdd sets a property on the type with this constant as
 * the key and the directive's unique ID as the value. This allows us to map directives to their
 * bloom filter bit for DI.
 */
// TODO(misko): This is wrong. The NG_ELEMENT_ID should never be minified.
export const NG_ELEMENT_ID = getClosureSafeProperty({ __NG_ELEMENT_ID__: getClosureSafeProperty });
/**
 * The `NG_ENV_ID` field on a DI token indicates special processing in the `EnvironmentInjector`:
 * getting such tokens from the `EnvironmentInjector` will bypass the standard DI resolution
 * strategy and instead will return implementation produced by the `NG_ENV_ID` factory function.
 *
 * This particular retrieval of DI tokens is mostly done to eliminate circular dependencies and
 * improve tree-shaking.
 */
export const NG_ENV_ID = getClosureSafeProperty({ __NG_ENV_ID__: getClosureSafeProperty });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmllbGRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9zcmMvcmVuZGVyMy9maWVsZHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUgsT0FBTyxFQUFDLHNCQUFzQixFQUFDLE1BQU0sa0JBQWtCLENBQUM7QUFFeEQsTUFBTSxDQUFDLE1BQU0sV0FBVyxHQUFHLHNCQUFzQixDQUFDLEVBQUMsSUFBSSxFQUFFLHNCQUFzQixFQUFDLENBQUMsQ0FBQztBQUNsRixNQUFNLENBQUMsTUFBTSxVQUFVLEdBQUcsc0JBQXNCLENBQUMsRUFBQyxJQUFJLEVBQUUsc0JBQXNCLEVBQUMsQ0FBQyxDQUFDO0FBQ2pGLE1BQU0sQ0FBQyxNQUFNLFdBQVcsR0FBRyxzQkFBc0IsQ0FBQyxFQUFDLEtBQUssRUFBRSxzQkFBc0IsRUFBQyxDQUFDLENBQUM7QUFDbkYsTUFBTSxDQUFDLE1BQU0sVUFBVSxHQUFHLHNCQUFzQixDQUFDLEVBQUMsSUFBSSxFQUFFLHNCQUFzQixFQUFDLENBQUMsQ0FBQztBQUNqRixNQUFNLENBQUMsTUFBTSxjQUFjLEdBQUcsc0JBQXNCLENBQUMsRUFBQyxJQUFJLEVBQUUsc0JBQXNCLEVBQUMsQ0FBQyxDQUFDO0FBRXJGOzs7O0dBSUc7QUFDSCwwRUFBMEU7QUFDMUUsTUFBTSxDQUFDLE1BQU0sYUFBYSxHQUFHLHNCQUFzQixDQUFDLEVBQUMsaUJBQWlCLEVBQUUsc0JBQXNCLEVBQUMsQ0FBQyxDQUFDO0FBRWpHOzs7Ozs7O0dBT0c7QUFDSCxNQUFNLENBQUMsTUFBTSxTQUFTLEdBQUcsc0JBQXNCLENBQUMsRUFBQyxhQUFhLEVBQUUsc0JBQXNCLEVBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuZGV2L2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge2dldENsb3N1cmVTYWZlUHJvcGVydHl9IGZyb20gJy4uL3V0aWwvcHJvcGVydHknO1xuXG5leHBvcnQgY29uc3QgTkdfQ09NUF9ERUYgPSBnZXRDbG9zdXJlU2FmZVByb3BlcnR5KHvJtWNtcDogZ2V0Q2xvc3VyZVNhZmVQcm9wZXJ0eX0pO1xuZXhwb3J0IGNvbnN0IE5HX0RJUl9ERUYgPSBnZXRDbG9zdXJlU2FmZVByb3BlcnR5KHvJtWRpcjogZ2V0Q2xvc3VyZVNhZmVQcm9wZXJ0eX0pO1xuZXhwb3J0IGNvbnN0IE5HX1BJUEVfREVGID0gZ2V0Q2xvc3VyZVNhZmVQcm9wZXJ0eSh7ybVwaXBlOiBnZXRDbG9zdXJlU2FmZVByb3BlcnR5fSk7XG5leHBvcnQgY29uc3QgTkdfTU9EX0RFRiA9IGdldENsb3N1cmVTYWZlUHJvcGVydHkoe8m1bW9kOiBnZXRDbG9zdXJlU2FmZVByb3BlcnR5fSk7XG5leHBvcnQgY29uc3QgTkdfRkFDVE9SWV9ERUYgPSBnZXRDbG9zdXJlU2FmZVByb3BlcnR5KHvJtWZhYzogZ2V0Q2xvc3VyZVNhZmVQcm9wZXJ0eX0pO1xuXG4vKipcbiAqIElmIGEgZGlyZWN0aXZlIGlzIGRpUHVibGljLCBibG9vbUFkZCBzZXRzIGEgcHJvcGVydHkgb24gdGhlIHR5cGUgd2l0aCB0aGlzIGNvbnN0YW50IGFzXG4gKiB0aGUga2V5IGFuZCB0aGUgZGlyZWN0aXZlJ3MgdW5pcXVlIElEIGFzIHRoZSB2YWx1ZS4gVGhpcyBhbGxvd3MgdXMgdG8gbWFwIGRpcmVjdGl2ZXMgdG8gdGhlaXJcbiAqIGJsb29tIGZpbHRlciBiaXQgZm9yIERJLlxuICovXG4vLyBUT0RPKG1pc2tvKTogVGhpcyBpcyB3cm9uZy4gVGhlIE5HX0VMRU1FTlRfSUQgc2hvdWxkIG5ldmVyIGJlIG1pbmlmaWVkLlxuZXhwb3J0IGNvbnN0IE5HX0VMRU1FTlRfSUQgPSBnZXRDbG9zdXJlU2FmZVByb3BlcnR5KHtfX05HX0VMRU1FTlRfSURfXzogZ2V0Q2xvc3VyZVNhZmVQcm9wZXJ0eX0pO1xuXG4vKipcbiAqIFRoZSBgTkdfRU5WX0lEYCBmaWVsZCBvbiBhIERJIHRva2VuIGluZGljYXRlcyBzcGVjaWFsIHByb2Nlc3NpbmcgaW4gdGhlIGBFbnZpcm9ubWVudEluamVjdG9yYDpcbiAqIGdldHRpbmcgc3VjaCB0b2tlbnMgZnJvbSB0aGUgYEVudmlyb25tZW50SW5qZWN0b3JgIHdpbGwgYnlwYXNzIHRoZSBzdGFuZGFyZCBESSByZXNvbHV0aW9uXG4gKiBzdHJhdGVneSBhbmQgaW5zdGVhZCB3aWxsIHJldHVybiBpbXBsZW1lbnRhdGlvbiBwcm9kdWNlZCBieSB0aGUgYE5HX0VOVl9JRGAgZmFjdG9yeSBmdW5jdGlvbi5cbiAqXG4gKiBUaGlzIHBhcnRpY3VsYXIgcmV0cmlldmFsIG9mIERJIHRva2VucyBpcyBtb3N0bHkgZG9uZSB0byBlbGltaW5hdGUgY2lyY3VsYXIgZGVwZW5kZW5jaWVzIGFuZFxuICogaW1wcm92ZSB0cmVlLXNoYWtpbmcuXG4gKi9cbmV4cG9ydCBjb25zdCBOR19FTlZfSUQgPSBnZXRDbG9zdXJlU2FmZVByb3BlcnR5KHtfX05HX0VOVl9JRF9fOiBnZXRDbG9zdXJlU2FmZVByb3BlcnR5fSk7XG4iXX0=