/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/**
 * @fileoverview
 * This file is the index file collecting all of the symbols published on the global.ng namespace.
 *
 * The reason why this file/module is separate global_utils.ts file is that we use this file
 * to generate a d.ts file containing all the published symbols that is then compared to the golden
 * file in the public_api_guard test.
 */
export { applyChanges } from './util/change_detection_utils';
export { getComponent, getContext, getDirectiveMetadata, getDirectives, getHostElement, getInjector, getListeners, getOwningComponent, getRootComponents, } from './util/discovery_utils';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2xvYmFsX3V0aWxzX2FwaS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvc3JjL3JlbmRlcjMvZ2xvYmFsX3V0aWxzX2FwaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSDs7Ozs7OztHQU9HO0FBRUgsT0FBTyxFQUFDLFlBQVksRUFBQyxNQUFNLCtCQUErQixDQUFDO0FBQzNELE9BQU8sRUFHTCxZQUFZLEVBQ1osVUFBVSxFQUNWLG9CQUFvQixFQUNwQixhQUFhLEVBQ2IsY0FBYyxFQUNkLFdBQVcsRUFDWCxZQUFZLEVBQ1osa0JBQWtCLEVBQ2xCLGlCQUFpQixHQUVsQixNQUFNLHdCQUF3QixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuZGV2L2xpY2Vuc2VcbiAqL1xuXG4vKipcbiAqIEBmaWxlb3ZlcnZpZXdcbiAqIFRoaXMgZmlsZSBpcyB0aGUgaW5kZXggZmlsZSBjb2xsZWN0aW5nIGFsbCBvZiB0aGUgc3ltYm9scyBwdWJsaXNoZWQgb24gdGhlIGdsb2JhbC5uZyBuYW1lc3BhY2UuXG4gKlxuICogVGhlIHJlYXNvbiB3aHkgdGhpcyBmaWxlL21vZHVsZSBpcyBzZXBhcmF0ZSBnbG9iYWxfdXRpbHMudHMgZmlsZSBpcyB0aGF0IHdlIHVzZSB0aGlzIGZpbGVcbiAqIHRvIGdlbmVyYXRlIGEgZC50cyBmaWxlIGNvbnRhaW5pbmcgYWxsIHRoZSBwdWJsaXNoZWQgc3ltYm9scyB0aGF0IGlzIHRoZW4gY29tcGFyZWQgdG8gdGhlIGdvbGRlblxuICogZmlsZSBpbiB0aGUgcHVibGljX2FwaV9ndWFyZCB0ZXN0LlxuICovXG5cbmV4cG9ydCB7YXBwbHlDaGFuZ2VzfSBmcm9tICcuL3V0aWwvY2hhbmdlX2RldGVjdGlvbl91dGlscyc7XG5leHBvcnQge1xuICBDb21wb25lbnREZWJ1Z01ldGFkYXRhLFxuICBEaXJlY3RpdmVEZWJ1Z01ldGFkYXRhLFxuICBnZXRDb21wb25lbnQsXG4gIGdldENvbnRleHQsXG4gIGdldERpcmVjdGl2ZU1ldGFkYXRhLFxuICBnZXREaXJlY3RpdmVzLFxuICBnZXRIb3N0RWxlbWVudCxcbiAgZ2V0SW5qZWN0b3IsXG4gIGdldExpc3RlbmVycyxcbiAgZ2V0T3duaW5nQ29tcG9uZW50LFxuICBnZXRSb290Q29tcG9uZW50cyxcbiAgTGlzdGVuZXIsXG59IGZyb20gJy4vdXRpbC9kaXNjb3ZlcnlfdXRpbHMnO1xuIl19