/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/*
 * This file re-exports all symbols contained in this directory.
 *
 * Why is this file not `index.ts`?
 *
 * There seems to be an inconsistent path resolution of an `index.ts` file
 * when only the parent directory is referenced. This could be due to the
 * node module resolution configuration differing from rollup and/or typescript.
 *
 * With commit
 * https://github.com/angular/angular/commit/d5e3f2c64bd13ce83e7c70788b7fc514ca4a9918
 * the `instructions.ts` file was moved to `instructions/instructions.ts` and an
 * `index.ts` file was used to re-export everything. Having had file names that were
 * importing from `instructions' directly (not the from the sub file or the `index.ts`
 * file) caused strange CI issues. `index.ts` had to be renamed to `all.ts` for this
 * to work.
 *
 * Jira Issue = FW-1184
 */
export * from '../../defer/instructions';
export * from './advance';
export * from './attribute';
export * from './attribute_interpolation';
export * from './change_detection';
export * from './class_map_interpolation';
export * from './component_instance';
export * from './control_flow';
export * from './di';
export * from './di_attr';
export * from './element';
export * from './element_container';
export { ɵgetUnknownElementStrictMode, ɵgetUnknownPropertyStrictMode, ɵsetUnknownElementStrictMode, ɵsetUnknownPropertyStrictMode, } from './element_validation';
export * from './get_current_view';
export * from './host_property';
export * from './i18n';
export * from './listener';
export * from './namespace';
export * from './next_context';
export * from './projection';
export * from './property';
export * from './property_interpolation';
export * from './queries';
export * from './queries_signals';
export * from './storage';
export * from './style_map_interpolation';
export * from './style_prop_interpolation';
export * from './styling';
export * from './template';
export * from './text';
export * from './text_interpolation';
export * from './two_way';
export * from './let_declaration';
//# sourceMappingURL=data:application/json;base64,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