/*!
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { assertDefined } from '../../util/assert';
import { CONTEXT, DECLARATION_COMPONENT_VIEW } from '../interfaces/view';
import { getLView } from '../state';
/**
 * Instruction that returns the component instance in which the current instruction is executing.
 * This is a constant-time version of `nextContent` for the case where we know that we need the
 * component instance specifically, rather than the context of a particular template.
 *
 * @codeGenApi
 */
export function ɵɵcomponentInstance() {
    const instance = getLView()[DECLARATION_COMPONENT_VIEW][CONTEXT];
    ngDevMode && assertDefined(instance, 'Expected component instance to be defined');
    return instance;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcG9uZW50X2luc3RhbmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9zcmMvcmVuZGVyMy9pbnN0cnVjdGlvbnMvY29tcG9uZW50X2luc3RhbmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQUVILE9BQU8sRUFBQyxhQUFhLEVBQUMsTUFBTSxtQkFBbUIsQ0FBQztBQUNoRCxPQUFPLEVBQUMsT0FBTyxFQUFFLDBCQUEwQixFQUFDLE1BQU0sb0JBQW9CLENBQUM7QUFDdkUsT0FBTyxFQUFDLFFBQVEsRUFBQyxNQUFNLFVBQVUsQ0FBQztBQUVsQzs7Ozs7O0dBTUc7QUFDSCxNQUFNLFVBQVUsbUJBQW1CO0lBQ2pDLE1BQU0sUUFBUSxHQUFHLFFBQVEsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDakUsU0FBUyxJQUFJLGFBQWEsQ0FBQyxRQUFRLEVBQUUsMkNBQTJDLENBQUMsQ0FBQztJQUNsRixPQUFPLFFBQVEsQ0FBQztBQUNsQixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyohXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuZGV2L2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge2Fzc2VydERlZmluZWR9IGZyb20gJy4uLy4uL3V0aWwvYXNzZXJ0JztcbmltcG9ydCB7Q09OVEVYVCwgREVDTEFSQVRJT05fQ09NUE9ORU5UX1ZJRVd9IGZyb20gJy4uL2ludGVyZmFjZXMvdmlldyc7XG5pbXBvcnQge2dldExWaWV3fSBmcm9tICcuLi9zdGF0ZSc7XG5cbi8qKlxuICogSW5zdHJ1Y3Rpb24gdGhhdCByZXR1cm5zIHRoZSBjb21wb25lbnQgaW5zdGFuY2UgaW4gd2hpY2ggdGhlIGN1cnJlbnQgaW5zdHJ1Y3Rpb24gaXMgZXhlY3V0aW5nLlxuICogVGhpcyBpcyBhIGNvbnN0YW50LXRpbWUgdmVyc2lvbiBvZiBgbmV4dENvbnRlbnRgIGZvciB0aGUgY2FzZSB3aGVyZSB3ZSBrbm93IHRoYXQgd2UgbmVlZCB0aGVcbiAqIGNvbXBvbmVudCBpbnN0YW5jZSBzcGVjaWZpY2FsbHksIHJhdGhlciB0aGFuIHRoZSBjb250ZXh0IG9mIGEgcGFydGljdWxhciB0ZW1wbGF0ZS5cbiAqXG4gKiBAY29kZUdlbkFwaVxuICovXG5leHBvcnQgZnVuY3Rpb24gybXJtWNvbXBvbmVudEluc3RhbmNlKCk6IHVua25vd24ge1xuICBjb25zdCBpbnN0YW5jZSA9IGdldExWaWV3KClbREVDTEFSQVRJT05fQ09NUE9ORU5UX1ZJRVddW0NPTlRFWFRdO1xuICBuZ0Rldk1vZGUgJiYgYXNzZXJ0RGVmaW5lZChpbnN0YW5jZSwgJ0V4cGVjdGVkIGNvbXBvbmVudCBpbnN0YW5jZSB0byBiZSBkZWZpbmVkJyk7XG4gIHJldHVybiBpbnN0YW5jZTtcbn1cbiJdfQ==