/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { FLAGS, HOST, NEXT, PARENT, T_HOST } from './view';
/**
 * Special location which allows easy identification of type. If we have an array which was
 * retrieved from the `LView` and that array has `true` at `TYPE` location, we know it is
 * `LContainer`.
 */
export const TYPE = 1;
/**
 * Below are constants for LContainer indices to help us look up LContainer members
 * without having to remember the specific indices.
 * Uglify will inline these when minifying so there shouldn't be a cost.
 */
// FLAGS, PARENT, NEXT, and T_HOST are indices 2, 3, 4, and 5
// As we already have these constants in LView, we don't need to re-create them.
export const DEHYDRATED_VIEWS = 6;
export const NATIVE = 7;
export const VIEW_REFS = 8;
export const MOVED_VIEWS = 9;
/**
 * Size of LContainer's header. Represents the index after which all views in the
 * container will be inserted. We need to keep a record of current views so we know
 * which views are already in the DOM (and don't need to be re-added) and so we can
 * remove views from the DOM when they are no longer required.
 */
export const CONTAINER_HEADER_OFFSET = 10;
/** Flags associated with an LContainer (saved in LContainer[FLAGS]) */
export var LContainerFlags;
(function (LContainerFlags) {
    LContainerFlags[LContainerFlags["None"] = 0] = "None";
    /**
     * Flag to signify that this `LContainer` may have transplanted views which need to be change
     * detected. (see: `LView[DECLARATION_COMPONENT_VIEW])`.
     *
     * This flag, once set, is never unset for the `LContainer`.
     */
    LContainerFlags[LContainerFlags["HasTransplantedViews"] = 2] = "HasTransplantedViews";
})(LContainerFlags || (LContainerFlags = {}));
//# sourceMappingURL=data:application/json;base64,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