/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/**
 * Marks that the next string is an element name.
 *
 * See `I18nMutateOpCodes` documentation.
 */
export const ELEMENT_MARKER = {
    marker: 'element',
};
/**
 * Marks that the next string is comment text need for ICU.
 *
 * See `I18nMutateOpCodes` documentation.
 */
export const ICU_MARKER = {
    marker: 'ICU',
};
/**
 * See `I18nCreateOpCodes`
 */
export var I18nCreateOpCode;
(function (I18nCreateOpCode) {
    /**
     * Number of bits to shift index so that it can be combined with the `APPEND_EAGERLY` and
     * `COMMENT`.
     */
    I18nCreateOpCode[I18nCreateOpCode["SHIFT"] = 2] = "SHIFT";
    /**
     * Should the node be appended to parent immediately after creation.
     */
    I18nCreateOpCode[I18nCreateOpCode["APPEND_EAGERLY"] = 1] = "APPEND_EAGERLY";
    /**
     * If set the node should be comment (rather than a text) node.
     */
    I18nCreateOpCode[I18nCreateOpCode["COMMENT"] = 2] = "COMMENT";
})(I18nCreateOpCode || (I18nCreateOpCode = {}));
//# sourceMappingURL=data:application/json;base64,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