/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { assertNumber, assertNumberInRange } from '../../util/assert';
export function toTStylingRange(prev, next) {
    ngDevMode && assertNumberInRange(prev, 0, 32767 /* StylingRange.UNSIGNED_MASK */);
    ngDevMode && assertNumberInRange(next, 0, 32767 /* StylingRange.UNSIGNED_MASK */);
    return ((prev << 17 /* StylingRange.PREV_SHIFT */) | (next << 2 /* StylingRange.NEXT_SHIFT */));
}
export function getTStylingRangePrev(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange >> 17 /* StylingRange.PREV_SHIFT */) & 32767 /* StylingRange.UNSIGNED_MASK */;
}
export function getTStylingRangePrevDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 2 /* StylingRange.PREV_DUPLICATE */) == 2 /* StylingRange.PREV_DUPLICATE */;
}
export function setTStylingRangePrev(tStylingRange, previous) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    ngDevMode && assertNumberInRange(previous, 0, 32767 /* StylingRange.UNSIGNED_MASK */);
    return ((tStylingRange & ~4294836224 /* StylingRange.PREV_MASK */) |
        (previous << 17 /* StylingRange.PREV_SHIFT */));
}
export function setTStylingRangePrevDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange | 2 /* StylingRange.PREV_DUPLICATE */);
}
export function getTStylingRangeNext(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 131068 /* StylingRange.NEXT_MASK */) >> 2 /* StylingRange.NEXT_SHIFT */;
}
export function setTStylingRangeNext(tStylingRange, next) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    ngDevMode && assertNumberInRange(next, 0, 32767 /* StylingRange.UNSIGNED_MASK */);
    return ((tStylingRange & ~131068 /* StylingRange.NEXT_MASK */) | //
        (next << 2 /* StylingRange.NEXT_SHIFT */));
}
export function getTStylingRangeNextDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange & 1 /* StylingRange.NEXT_DUPLICATE */) === 1 /* StylingRange.NEXT_DUPLICATE */;
}
export function setTStylingRangeNextDuplicate(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    return (tStylingRange | 1 /* StylingRange.NEXT_DUPLICATE */);
}
export function getTStylingRangeTail(tStylingRange) {
    ngDevMode && assertNumber(tStylingRange, 'expected number');
    const next = getTStylingRangeNext(tStylingRange);
    return next === 0 ? getTStylingRangePrev(tStylingRange) : next;
}
//# sourceMappingURL=data:application/json;base64,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