/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
// Below are constants for LView indices to help us look up LView members
// without having to remember the specific indices.
// Uglify will inline these when minifying so there shouldn't be a cost.
export const HOST = 0;
export const TVIEW = 1;
// Shared with LContainer
export const FLAGS = 2;
export const PARENT = 3;
export const NEXT = 4;
export const T_HOST = 5;
// End shared with LContainer
export const HYDRATION = 6;
export const CLEANUP = 7;
export const CONTEXT = 8;
export const INJECTOR = 9;
export const ENVIRONMENT = 10;
export const RENDERER = 11;
export const CHILD_HEAD = 12;
export const CHILD_TAIL = 13;
// FIXME(misko): Investigate if the three declarations aren't all same thing.
export const DECLARATION_VIEW = 14;
export const DECLARATION_COMPONENT_VIEW = 15;
export const DECLARATION_LCONTAINER = 16;
export const PREORDER_HOOK_FLAGS = 17;
export const QUERIES = 18;
export const ID = 19;
export const EMBEDDED_VIEW_INJECTOR = 20;
export const ON_DESTROY_HOOKS = 21;
export const EFFECTS_TO_SCHEDULE = 22;
export const REACTIVE_TEMPLATE_CONSUMER = 23;
/**
 * Size of LView's header. Necessary to adjust for it when setting slots.
 *
 * IMPORTANT: `HEADER_OFFSET` should only be referred to the in the `ɵɵ*` instructions to translate
 * instruction index into `LView` index. All other indexes should be in the `LView` index space and
 * there should be no need to refer to `HEADER_OFFSET` anywhere else.
 */
export const HEADER_OFFSET = 25;
//# sourceMappingURL=data:application/json;base64,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