/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { createComputed, SIGNAL } from '@angular/core/primitives/signals';
import { performanceMarkFeature } from '../../util/performance';
/**
 * Create a computed `Signal` which derives a reactive value from an expression.
 */
export function computed(computation, options) {
    performanceMarkFeature('NgSignals');
    const getter = createComputed(computation);
    if (options?.equal) {
        getter[SIGNAL].equal = options.equal;
    }
    if (ngDevMode) {
        getter.toString = () => `[Computed: ${getter()}]`;
    }
    return getter;
}
//# sourceMappingURL=data:application/json;base64,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