/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
import { setActiveConsumer } from '@angular/core/primitives/signals';
/**
 * Execute an arbitrary function in a non-reactive (non-tracking) context. The executed function
 * can, optionally, return a value.
 */
export function untracked(nonReactiveReadsFn) {
    const prevConsumer = setActiveConsumer(null);
    // We are not trying to catch any particular errors here, just making sure that the consumers
    // stack is restored in case of errors.
    try {
        return nonReactiveReadsFn();
    }
    finally {
        setActiveConsumer(prevConsumer);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidW50cmFja2VkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9zcmMvcmVuZGVyMy9yZWFjdGl2aXR5L3VudHJhY2tlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSCxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSxrQ0FBa0MsQ0FBQztBQUVuRTs7O0dBR0c7QUFDSCxNQUFNLFVBQVUsU0FBUyxDQUFJLGtCQUEyQjtJQUN0RCxNQUFNLFlBQVksR0FBRyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUM3Qyw2RkFBNkY7SUFDN0YsdUNBQXVDO0lBQ3ZDLElBQUksQ0FBQztRQUNILE9BQU8sa0JBQWtCLEVBQUUsQ0FBQztJQUM5QixDQUFDO1lBQVMsQ0FBQztRQUNULGlCQUFpQixDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQ2xDLENBQUM7QUFDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuZGV2L2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge3NldEFjdGl2ZUNvbnN1bWVyfSBmcm9tICdAYW5ndWxhci9jb3JlL3ByaW1pdGl2ZXMvc2lnbmFscyc7XG5cbi8qKlxuICogRXhlY3V0ZSBhbiBhcmJpdHJhcnkgZnVuY3Rpb24gaW4gYSBub24tcmVhY3RpdmUgKG5vbi10cmFja2luZykgY29udGV4dC4gVGhlIGV4ZWN1dGVkIGZ1bmN0aW9uXG4gKiBjYW4sIG9wdGlvbmFsbHksIHJldHVybiBhIHZhbHVlLlxuICovXG5leHBvcnQgZnVuY3Rpb24gdW50cmFja2VkPFQ+KG5vblJlYWN0aXZlUmVhZHNGbjogKCkgPT4gVCk6IFQge1xuICBjb25zdCBwcmV2Q29uc3VtZXIgPSBzZXRBY3RpdmVDb25zdW1lcihudWxsKTtcbiAgLy8gV2UgYXJlIG5vdCB0cnlpbmcgdG8gY2F0Y2ggYW55IHBhcnRpY3VsYXIgZXJyb3JzIGhlcmUsIGp1c3QgbWFraW5nIHN1cmUgdGhhdCB0aGUgY29uc3VtZXJzXG4gIC8vIHN0YWNrIGlzIHJlc3RvcmVkIGluIGNhc2Ugb2YgZXJyb3JzLlxuICB0cnkge1xuICAgIHJldHVybiBub25SZWFjdGl2ZVJlYWRzRm4oKTtcbiAgfSBmaW5hbGx5IHtcbiAgICBzZXRBY3RpdmVDb25zdW1lcihwcmV2Q29uc3VtZXIpO1xuICB9XG59XG4iXX0=