/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.dev/license
 */
/**
 * @module
 * @description
 * This module is used for handling user input, by defining and building a `FormGroup` that
 * consists of `FormControl` objects, and mapping them onto the DOM. `FormControl`
 * objects can then be used to read information from the form DOM elements.
 *
 * Forms providers are not included in default providers; you must import these providers
 * explicitly.
 */
export { ɵInternalFormsSharedModule } from './directives';
export { AbstractControlDirective } from './directives/abstract_control_directive';
export { AbstractFormGroupDirective } from './directives/abstract_form_group_directive';
export { CheckboxControlValueAccessor } from './directives/checkbox_value_accessor';
export { ControlContainer } from './directives/control_container';
export { NG_VALUE_ACCESSOR } from './directives/control_value_accessor';
export { COMPOSITION_BUFFER_MODE, DefaultValueAccessor } from './directives/default_value_accessor';
export { NgControl } from './directives/ng_control';
export { NgControlStatus, NgControlStatusGroup } from './directives/ng_control_status';
export { NgForm } from './directives/ng_form';
export { NgModel } from './directives/ng_model';
export { NgModelGroup } from './directives/ng_model_group';
export { ɵNgNoValidate } from './directives/ng_no_validate_directive';
export { NumberValueAccessor } from './directives/number_value_accessor';
export { RadioControlValueAccessor } from './directives/radio_control_value_accessor';
export { RangeValueAccessor } from './directives/range_value_accessor';
export { FormControlDirective } from './directives/reactive_directives/form_control_directive';
export { FormControlName } from './directives/reactive_directives/form_control_name';
export { FormGroupDirective } from './directives/reactive_directives/form_group_directive';
export { FormArrayName, FormGroupName } from './directives/reactive_directives/form_group_name';
export { NgSelectOption, SelectControlValueAccessor, } from './directives/select_control_value_accessor';
export { SelectMultipleControlValueAccessor, ɵNgSelectMultipleOption, } from './directives/select_multiple_control_value_accessor';
export { CheckboxRequiredValidator, EmailValidator, MaxLengthValidator, MaxValidator, MinLengthValidator, MinValidator, PatternValidator, RequiredValidator, } from './directives/validators';
export { FormBuilder, NonNullableFormBuilder, UntypedFormBuilder, } from './form_builder';
export { AbstractControl, ControlEvent, FormResetEvent, FormSubmittedEvent, PristineChangeEvent, StatusChangeEvent, TouchedChangeEvent, ValueChangeEvent, } from './model/abstract_model';
export { FormArray, isFormArray, UntypedFormArray, } from './model/form_array';
export { FormControl, isFormControl, UntypedFormControl, } from './model/form_control';
export { FormGroup, FormRecord, isFormGroup, isFormRecord, UntypedFormGroup, } from './model/form_group';
export { NG_ASYNC_VALIDATORS, NG_VALIDATORS, Validators } from './validators';
export { VERSION } from './version';
export * from './form_providers';
//# sourceMappingURL=data:application/json;base64,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