"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@inquirer/core");
function isStepOf(value, step, min) {
    const valuePow = value * Math.pow(10, 6);
    const stepPow = step * Math.pow(10, 6);
    const minPow = min * Math.pow(10, 6);
    return (valuePow - (Number.isFinite(min) ? minPow : 0)) % stepPow === 0;
}
function validateNumber(value, { min, max, step, }) {
    if (value == null || Number.isNaN(value)) {
        return false;
    }
    else if (value < min || value > max) {
        return `Value must be between ${min} and ${max}`;
    }
    else if (step !== 'any' && !isStepOf(value, step, min)) {
        return `Value must be a multiple of ${step}${Number.isFinite(min) ? ` starting from ${min}` : ''}`;
    }
    return true;
}
exports.default = (0, core_1.createPrompt)((config, done) => {
    var _a;
    const { validate = () => true, min = -Infinity, max = Infinity, step = 1, required = false, } = config;
    const theme = (0, core_1.makeTheme)(config.theme);
    const [status, setStatus] = (0, core_1.useState)('pending');
    const [value, setValue] = (0, core_1.useState)(''); // store the input value as string and convert to number on "Enter"
    // Ignore default if not valid.
    const validDefault = validateNumber(config.default, { min, max, step }) === true
        ? (_a = config.default) === null || _a === void 0 ? void 0 : _a.toString()
        : undefined;
    const [defaultValue = '', setDefaultValue] = (0, core_1.useState)(validDefault);
    const [errorMsg, setError] = (0, core_1.useState)();
    const isLoading = status === 'loading';
    const prefix = (0, core_1.usePrefix)({ isLoading, theme });
    (0, core_1.useKeypress)((key, rl) => __awaiter(void 0, void 0, void 0, function* () {
        // Ignore keypress while our prompt is doing other processing.
        if (status !== 'pending') {
            return;
        }
        if ((0, core_1.isEnterKey)(key)) {
            const input = value || defaultValue;
            const answer = input === '' ? undefined : Number(input);
            setStatus('loading');
            let isValid = true;
            if (required || answer != null) {
                isValid = validateNumber(answer, { min, max, step });
            }
            if (isValid === true) {
                isValid = yield validate(answer);
            }
            if (isValid === true) {
                setValue(String(answer !== null && answer !== void 0 ? answer : ''));
                setStatus('done');
                done(answer);
            }
            else {
                // Reset the readline line value to the previous value. On line event, the value
                // get cleared, forcing the user to re-enter the value instead of fixing it.
                rl.write(value);
                setError(isValid || 'You must provide a valid numeric value');
                setStatus('pending');
            }
        }
        else if ((0, core_1.isBackspaceKey)(key) && !value) {
            setDefaultValue(undefined);
        }
        else if (key.name === 'tab' && !value) {
            setDefaultValue(undefined);
            rl.clearLine(0); // Remove the tab character.
            rl.write(defaultValue);
            setValue(defaultValue);
        }
        else {
            setValue(rl.line);
            setError(undefined);
        }
    }));
    const message = theme.style.message(config.message);
    let formattedValue = value;
    if (status === 'done') {
        formattedValue = theme.style.answer(value);
    }
    let defaultStr;
    if (defaultValue && status !== 'done' && !value) {
        defaultStr = theme.style.defaultAnswer(defaultValue);
    }
    let error = '';
    if (errorMsg) {
        error = theme.style.error(errorMsg);
    }
    return [
        [prefix, message, defaultStr, formattedValue]
            .filter((v) => v !== undefined)
            .join(' '),
        error,
    ];
});
