import { reflow } from '../util/util';
/**
 * Defines the carousel slide transition direction.
 */
export var NgbSlideEventDirection;
(function (NgbSlideEventDirection) {
    NgbSlideEventDirection["START"] = "start";
    NgbSlideEventDirection["END"] = "end";
})(NgbSlideEventDirection || (NgbSlideEventDirection = {}));
const isBeingAnimated = ({ classList }) => {
    return classList.contains('carousel-item-start') || classList.contains('carousel-item-end');
};
const removeDirectionClasses = (classList) => {
    classList.remove('carousel-item-start', 'carousel-item-end');
};
const removeClasses = (classList) => {
    removeDirectionClasses(classList);
    classList.remove('carousel-item-prev', 'carousel-item-next');
};
export const ngbCarouselTransitionIn = (element, animation, { direction }) => {
    const { classList } = element;
    if (!animation) {
        removeClasses(classList);
        classList.add('active');
        return;
    }
    if (isBeingAnimated(element)) {
        // Revert the transition
        removeDirectionClasses(classList);
    }
    else {
        // For the 'in' transition, a 'pre-class' is applied to the element to ensure its visibility
        classList.add('carousel-item-' + (direction === NgbSlideEventDirection.START ? 'next' : 'prev'));
        reflow(element);
        classList.add('carousel-item-' + direction);
    }
    return () => {
        removeClasses(classList);
        classList.add('active');
    };
};
export const ngbCarouselTransitionOut = (element, animation, { direction }) => {
    const { classList } = element;
    if (!animation) {
        removeClasses(classList);
        classList.remove('active');
        return;
    }
    //  direction is left or right, depending on the way the slide goes out.
    if (isBeingAnimated(element)) {
        // Revert the transition
        removeDirectionClasses(classList);
    }
    else {
        classList.add('carousel-item-' + direction);
    }
    return () => {
        removeClasses(classList);
        classList.remove('active');
    };
};
//# sourceMappingURL=data:application/json;base64,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