import { Injectable } from '@angular/core';
import { isInteger } from '../../util/util';
import { NgbCalendarGregorian } from '../ngb-calendar';
import { fromGregorian, toGregorian } from './buddhist';
import * as i0 from "@angular/core";
/**
 * @since 9.1.0
 */
export class NgbCalendarBuddhist extends NgbCalendarGregorian {
    getToday() {
        return fromGregorian(new Date());
    }
    getNext(date, period = 'd', number = 1) {
        let jsDate = toGregorian(date);
        let checkMonth = true;
        let expectedMonth = jsDate.getMonth();
        switch (period) {
            case 'y':
                jsDate.setFullYear(jsDate.getFullYear() + number);
                break;
            case 'm':
                expectedMonth += number;
                jsDate.setMonth(expectedMonth);
                expectedMonth = expectedMonth % 12;
                if (expectedMonth < 0) {
                    expectedMonth = expectedMonth + 12;
                }
                break;
            case 'd':
                jsDate.setDate(jsDate.getDate() + number);
                checkMonth = false;
                break;
            default:
                return date;
        }
        if (checkMonth && jsDate.getMonth() !== expectedMonth) {
            // this means the destination month has less days than the initial month
            // let's go back to the end of the previous month:
            jsDate.setDate(0);
        }
        return fromGregorian(jsDate);
    }
    getPrev(date, period = 'd', number = 1) {
        return this.getNext(date, period, -number);
    }
    getWeekday(date) {
        let jsDate = toGregorian(date);
        let day = jsDate.getDay();
        // in JS Date Sun=0, in ISO 8601 Sun=7
        return day === 0 ? 7 : day;
    }
    getWeekNumber(week, firstDayOfWeek) {
        // in JS Date Sun=0, in ISO 8601 Sun=7
        if (firstDayOfWeek === 7) {
            firstDayOfWeek = 0;
        }
        const thursdayIndex = (4 + 7 - firstDayOfWeek) % 7;
        let date = week[thursdayIndex];
        const jsDate = toGregorian(date);
        jsDate.setDate(jsDate.getDate() + 4 - (jsDate.getDay() || 7)); // Thursday
        const time = jsDate.getTime();
        jsDate.setMonth(0); // Compare with Jan 1
        jsDate.setDate(1);
        return Math.floor(Math.round((time - jsDate.getTime()) / 86400000) / 7) + 1;
    }
    isValid(date) {
        if (!date || !isInteger(date.year) || !isInteger(date.month) || !isInteger(date.day)) {
            return false;
        }
        // year 0 doesn't exist in Gregorian calendar
        if (date.year === 0) {
            return false;
        }
        const jsDate = toGregorian(date);
        return (!isNaN(jsDate.getTime()) &&
            jsDate.getFullYear() === date.year - 543 &&
            jsDate.getMonth() + 1 === date.month &&
            jsDate.getDate() === date.day);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbCalendarBuddhist, deps: null, target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbCalendarBuddhist }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbCalendarBuddhist, decorators: [{
            type: Injectable
        }] });
//# sourceMappingURL=data:application/json;base64,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