import { Injectable } from '@angular/core';
import { isInteger } from '../../util/util';
import { NgbCalendar } from '../ngb-calendar';
import { NgbDate } from '../ngb-date';
import { ethiopianToJulian, fromGregorian, setEthiopianDay, setEthiopianMonth, setEthiopianYear, toGregorian, } from './ethiopian';
import * as i0 from "@angular/core";
/**
 * @since 16.0.0
 */
export class NgbCalendarEthiopian extends NgbCalendar {
    getDaysPerWeek() {
        return 7;
    }
    getMonths(year) {
        return [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13];
    }
    getNext(date, period = 'd', number = 1) {
        date = new NgbDate(date.year, date.month, date.day);
        switch (period) {
            case 'y':
                date = setEthiopianYear(date, date.year + number);
                date.month = 1;
                date.day = 1;
                return date;
            case 'm':
                date = setEthiopianMonth(date, date.month + number);
                date.day = 1;
                return date;
            case 'd':
                return setEthiopianDay(date, date.day + number);
            default:
                return date;
        }
    }
    getPrev(date, period = 'd', number = 1) {
        return this.getNext(date, period, -number);
    }
    getWeekday(date) {
        const dt = Math.floor(ethiopianToJulian(date.year, date.month, date.day) + 3) % 7;
        return dt === 0 ? 7 : dt;
    }
    getWeekNumber(week, firstDayOfWeek) {
        if (firstDayOfWeek === 7) {
            firstDayOfWeek = 0;
        }
        const thursdayIndex = (4 + 7 - firstDayOfWeek) % 7;
        const date = week[thursdayIndex];
        const jsDate = toGregorian(date);
        jsDate.setDate(jsDate.getDate() + 4 - (jsDate.getDay() || 7)); // Thursday
        const time = jsDate.getTime();
        const startDate = toGregorian(new NgbDate(date.year, 1, 1));
        return Math.floor(Math.round((time - startDate.getTime()) / 86400000) / 7) + 1;
    }
    getWeeksPerMonth() {
        return 6;
    }
    getToday() {
        return fromGregorian(new Date());
    }
    isValid(date) {
        return (date &&
            isInteger(date.year) &&
            isInteger(date.month) &&
            isInteger(date.day) &&
            !isNaN(toGregorian(date).getTime()));
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbCalendarEthiopian, deps: null, target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbCalendarEthiopian }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbCalendarEthiopian, decorators: [{
            type: Injectable
        }] });
//# sourceMappingURL=data:application/json;base64,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