import { inject, Injectable } from '@angular/core';
import { NgbConfig } from '../ngb-config';
import * as i0 from "@angular/core";
/**
 * A configuration service for the [`NgbModal`](#/components/modal/api#NgbModal) service.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all modals used in the application.
 *
 * @since 3.1.0
 */
export class NgbModalConfig {
    constructor() {
        this._ngbConfig = inject(NgbConfig);
        this.backdrop = true;
        this.fullscreen = false;
        this.keyboard = true;
    }
    get animation() {
        return this._animation ?? this._ngbConfig.animation;
    }
    set animation(animation) {
        this._animation = animation;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbModalConfig, deps: [], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbModalConfig, providedIn: 'root' }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbModalConfig, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }] });
//# sourceMappingURL=data:application/json;base64,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