import { inject, Injectable } from '@angular/core';
import { NgbConfig } from '../ngb-config';
import * as i0 from "@angular/core";
/**
 * A configuration service for the [`NgbOffcanvas`](#/components/offcanvas/api#NgbOffcanvas) service.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all offcanvases used in the application.
 *
 * @since 12.1.0
 */
export class NgbOffcanvasConfig {
    constructor() {
        this._ngbConfig = inject(NgbConfig);
        this.backdrop = true;
        this.keyboard = true;
        this.position = 'start';
        this.scroll = false;
    }
    get animation() {
        return this._animation ?? this._ngbConfig.animation;
    }
    set animation(animation) {
        this._animation = animation;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbOffcanvasConfig, deps: [], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbOffcanvasConfig, providedIn: 'root' }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.0.2", ngImport: i0, type: NgbOffcanvasConfig, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }] });
//# sourceMappingURL=data:application/json;base64,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