import { Observable } from 'rxjs';
export function toInteger(value) {
    return parseInt(`${value}`, 10);
}
export function toString(value) {
    return value !== undefined && value !== null ? `${value}` : '';
}
export function getValueInRange(value, max, min = 0) {
    return Math.max(Math.min(value, max), min);
}
export function isString(value) {
    return typeof value === 'string';
}
export function isNumber(value) {
    return !isNaN(toInteger(value));
}
export function isInteger(value) {
    return typeof value === 'number' && isFinite(value) && Math.floor(value) === value;
}
export function isDefined(value) {
    return value !== undefined && value !== null;
}
export function isPromise(v) {
    return v && v.then;
}
export function padNumber(value) {
    if (isNumber(value)) {
        return `0${value}`.slice(-2);
    }
    else {
        return '';
    }
}
export function regExpEscape(text) {
    return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
}
export function closest(element, selector) {
    if (!selector) {
        return null;
    }
    /*
     * In certain browsers (e.g. Edge 44.18362.449.0) HTMLDocument does
     * not support `Element.prototype.closest`. To emulate the correct behaviour
     * we return null when the method is missing.
     *
     * Note that in evergreen browsers `closest(document.documentElement, 'html')`
     * will return the document element whilst in Edge null will be returned. This
     * compromise was deemed good enough.
     */
    if (typeof element.closest === 'undefined') {
        return null;
    }
    return element.closest(selector);
}
/**
 * Force a browser reflow
 * @param element element where to apply the reflow
 */
export function reflow(element) {
    return (element || document.body).getBoundingClientRect();
}
/**
 * Creates an observable where all callbacks are executed inside a given zone
 *
 * @param zone
 */
export function runInZone(zone) {
    return (source) => {
        return new Observable((observer) => {
            const next = (value) => zone.run(() => observer.next(value));
            const error = (e) => zone.run(() => observer.error(e));
            const complete = () => zone.run(() => observer.complete());
            return source.subscribe({ next, error, complete });
        });
    };
}
export function removeAccents(str) {
    return str.normalize('NFD').replace(/[\u0300-\u036f]/g, '');
}
/**
 * Returns the active element in the given root.
 * If the active element is inside a shadow root, it is searched recursively.
 */
export function getActiveElement(root = document) {
    const activeEl = root?.activeElement;
    if (!activeEl) {
        return null;
    }
    return activeEl.shadowRoot ? getActiveElement(activeEl.shadowRoot) : activeEl;
}
//# sourceMappingURL=data:application/json;base64,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