"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDestination = getDestination;
exports.getNewProjectName = getNewProjectName;
exports.normalizePathSlashes = normalizePathSlashes;
const devkit_1 = require("@nx/devkit");
/**
 * This helper function ensures that we don't move libs or apps
 * outside of the folders they should be in.
 *
 * This will break if someone isn't using the default libs/apps
 * folders. In that case, they're on their own :/
 */
function getDestination(host, schema, project) {
    const projectType = project.projectType;
    const workspaceLayout = (0, devkit_1.getWorkspaceLayout)(host);
    let rootFolder = workspaceLayout.libsDir;
    if (projectType === 'application') {
        rootFolder = workspaceLayout.appsDir;
    }
    return (0, devkit_1.joinPathFragments)(rootFolder, schema.destination);
}
/**
 * Joins path segments replacing slashes with dashes
 *
 * @param path
 */
function getNewProjectName(path) {
    // strip leading '/' or './' or '../' and trailing '/' and replaces '/' with '-'
    return (0, devkit_1.normalizePath)(path)
        .replace(/(^\.{0,2}\/|\.{1,2}\/|\/$)/g, '')
        .split('/')
        .filter((x) => !!x)
        .join('-');
}
/**
 * Normalizes slashes (removes duplicates)
 *
 * @param input
 */
function normalizePathSlashes(input) {
    return ((0, devkit_1.normalizePath)(input)
        // strip leading ./ or /
        .replace(/^\.?\//, '')
        .split('/')
        .filter((x) => !!x)
        .join('/'));
}
