import { PackageManager, Tree } from '@nx/devkit';
import { Linter, LinterType } from '../../utils/lint';
interface Schema {
    directory: string;
    name: string;
    appName?: string;
    skipInstall?: boolean;
    style?: string;
    preset: string;
    defaultBase: string;
    framework?: string;
    docker?: boolean;
    js?: boolean;
    nextAppDir?: boolean;
    nextSrcDir?: boolean;
    linter?: Linter | LinterType;
    bundler?: 'vite' | 'webpack';
    standaloneApi?: boolean;
    routing?: boolean;
    packageManager?: PackageManager;
    e2eTestRunner?: 'cypress' | 'playwright' | 'detox' | 'jest' | 'none';
    ssr?: boolean;
    prefix?: string;
    useGitHub?: boolean;
    nxCloud?: 'yes' | 'skip' | 'circleci' | 'github';
}
export interface NormalizedSchema extends Schema {
    presetVersion?: string;
    isCustomPreset: boolean;
    nxCloudToken?: string;
}
export declare function newGenerator(tree: Tree, opts: Schema): Promise<() => Promise<void>>;
export default newGenerator;
