"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.presetGenerator = presetGenerator;
const devkit_1 = require("@nx/devkit");
const presets_1 = require("../utils/presets");
const path_1 = require("path");
async function presetGenerator(tree, options) {
    const presetTask = await createPreset(tree, options);
    return async () => {
        (0, devkit_1.installPackagesTask)(tree);
        if (presetTask)
            await presetTask();
    };
}
exports.default = presetGenerator;
async function createPreset(tree, options) {
    const nxJson = (0, devkit_1.readNxJson)(tree);
    const addPlugin = process.env.NX_ADD_PLUGINS !== 'false' &&
        nxJson.useInferencePlugins !== false;
    if (options.preset === presets_1.Preset.Apps) {
        return;
    }
    else if (options.preset === presets_1.Preset.AngularMonorepo) {
        const { applicationGenerator: angularApplicationGenerator, } = require('@nx' + '/angular/generators');
        return angularApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            standalone: options.standaloneApi,
            routing: options.routing,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            bundler: options.bundler,
            ssr: options.ssr,
            prefix: options.prefix,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.AngularStandalone) {
        const { applicationGenerator: angularApplicationGenerator, } = require('@nx' + '/angular/generators');
        return angularApplicationGenerator(tree, {
            name: options.name,
            directory: '.',
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            routing: options.routing,
            rootProject: true,
            standalone: options.standaloneApi,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            bundler: options.bundler,
            ssr: options.ssr,
            prefix: options.prefix,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.ReactMonorepo) {
        const { applicationGenerator: reactApplicationGenerator } = require('@nx' +
            '/react');
        return reactApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            bundler: options.bundler ?? 'webpack',
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.ReactStandalone) {
        const { applicationGenerator: reactApplicationGenerator } = require('@nx' +
            '/react');
        return reactApplicationGenerator(tree, {
            name: options.name,
            directory: '.',
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            rootProject: true,
            bundler: options.bundler ?? 'vite',
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            unitTestRunner: options.bundler === 'vite' ? 'vitest' : 'jest',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.RemixMonorepo) {
        const { applicationGenerator: remixApplicationGenerator } = require('@nx' +
            '/remix/generators');
        return remixApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            linter: options.linter,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            unitTestRunner: 'vitest',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.RemixStandalone) {
        const { applicationGenerator: remixApplicationGenerator } = require('@nx' +
            '/remix/generators');
        return remixApplicationGenerator(tree, {
            name: options.name,
            directory: '.',
            projectNameAndRootFormat: 'as-provided',
            linter: options.linter,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            rootProject: true,
            unitTestRunner: 'vitest',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.VueMonorepo) {
        const { applicationGenerator: vueApplicationGenerator } = require('@nx' +
            '/vue');
        return vueApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.VueStandalone) {
        const { applicationGenerator: vueApplicationGenerator } = require('@nx' +
            '/vue');
        return vueApplicationGenerator(tree, {
            name: options.name,
            directory: '.',
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            rootProject: true,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            unitTestRunner: 'vitest',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.Nuxt) {
        const { applicationGenerator: nuxtApplicationGenerator } = require('@nx' +
            '/nuxt');
        return nuxtApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.NuxtStandalone) {
        const { applicationGenerator: nuxtApplicationGenerator } = require('@nx' +
            '/nuxt');
        return nuxtApplicationGenerator(tree, {
            name: options.name,
            directory: '.',
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            rootProject: true,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            unitTestRunner: 'vitest',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.NextJs) {
        const { applicationGenerator: nextApplicationGenerator } = require('@nx' +
            '/next');
        return nextApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            appDir: options.nextAppDir,
            src: options.nextSrcDir,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            addPlugin,
        });
    }
    else if (options.preset === presets_1.Preset.NextJsStandalone) {
        const { applicationGenerator: nextApplicationGenerator } = require('@nx' +
            '/next');
        return nextApplicationGenerator(tree, {
            name: options.name,
            directory: '.',
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            appDir: options.nextAppDir,
            src: options.nextSrcDir,
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            rootProject: true,
            addPlugin,
        });
    }
    else if (options.preset === presets_1.Preset.WebComponents) {
        const { applicationGenerator: webApplicationGenerator } = require('@nx' +
            '/web');
        return webApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            style: options.style,
            linter: options.linter,
            bundler: 'vite',
            e2eTestRunner: options.e2eTestRunner ?? 'playwright',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.Nest) {
        const { applicationGenerator: nestApplicationGenerator } = require('@nx' +
            '/nest');
        return nestApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            linter: options.linter,
            e2eTestRunner: options.e2eTestRunner ?? 'jest',
            addPlugin,
        });
    }
    else if (options.preset === presets_1.Preset.Express) {
        const { applicationGenerator: expressApplicationGenerator, } = require('@nx' + '/express');
        return expressApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            linter: options.linter,
            e2eTestRunner: options.e2eTestRunner ?? 'jest',
            addPlugin,
        });
    }
    else if (options.preset === presets_1.Preset.ReactNative) {
        const { reactNativeApplicationGenerator } = require('@nx' +
            '/react-native');
        return reactNativeApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            linter: options.linter,
            e2eTestRunner: options.e2eTestRunner ?? 'detox',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.Expo) {
        const { expoApplicationGenerator } = require('@nx' + '/expo');
        return expoApplicationGenerator(tree, {
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            linter: options.linter,
            e2eTestRunner: options.e2eTestRunner ?? 'detox',
            addPlugin,
            nxCloudToken: options.nxCloudToken,
        });
    }
    else if (options.preset === presets_1.Preset.TS) {
        const { initGenerator } = require('@nx' + '/js');
        return initGenerator(tree, {});
    }
    else if (options.preset === presets_1.Preset.TsStandalone) {
        const { libraryGenerator } = require('@nx' + '/js');
        return libraryGenerator(tree, {
            name: options.name,
            directory: '.',
            projectNameAndRootFormat: 'as-provided',
            bundler: 'tsc',
            unitTestRunner: 'vitest',
            testEnvironment: 'node',
            js: options.js,
            rootProject: true,
            addPlugin,
        });
    }
    else if (options.preset === presets_1.Preset.NodeStandalone) {
        const { applicationGenerator: nodeApplicationGenerator } = require('@nx' +
            '/node');
        const bundler = options.bundler === 'webpack' ? 'webpack' : 'esbuild';
        return nodeApplicationGenerator(tree, {
            bundler,
            name: options.name,
            directory: '.',
            projectNameAndRootFormat: 'as-provided',
            linter: options.linter,
            standaloneConfig: options.standaloneConfig,
            framework: options.framework,
            docker: options.docker,
            rootProject: true,
            e2eTestRunner: options.e2eTestRunner ?? 'jest',
            addPlugin,
        });
    }
    else if (options.preset === presets_1.Preset.NodeMonorepo) {
        const { applicationGenerator: nodeApplicationGenerator } = require('@nx' +
            '/node');
        const bundler = options.bundler === 'webpack' ? 'webpack' : 'esbuild';
        return nodeApplicationGenerator(tree, {
            bundler,
            name: options.name,
            directory: (0, path_1.join)('apps', options.name),
            projectNameAndRootFormat: 'as-provided',
            linter: options.linter,
            framework: options.framework,
            docker: options.docker,
            rootProject: false,
            e2eTestRunner: options.e2eTestRunner ?? 'jest',
            addPlugin,
        });
    }
    else {
        throw new Error(`Invalid preset ${options.preset}`);
    }
}
